/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.arquillian.container.chameleon.ChameleonConfiguration;
import org.arquillian.container.chameleon.ChameleonContainer;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitiateContainer {
    public void setup(@Observes EventContext<SetupContainer> setup) throws Exception {
        SetupContainer event = (SetupContainer)setup.getEvent();
        if (this.isChameleonContainer(event)) {
            this.initiateChameleon(event);
        }
        setup.proceed();
    }

    private boolean isChameleonContainer(SetupContainer event) {
        return event.getContainer().getDeployableContainer() instanceof ChameleonContainer;
    }

    private void initiateChameleon(SetupContainer setup) throws NoSuchFieldException, IllegalAccessException {
        ChameleonContainer container = (ChameleonContainer)setup.getContainer().getDeployableContainer();
        if (container.isInitiated()) {
            return;
        }
        ContainerDefImpl containerDef = (ContainerDefImpl)setup.getContainer().getContainerConfiguration();
        Field containerNodeField = ContainerDefImpl.class.getDeclaredField("container");
        if (!containerNodeField.isAccessible()) {
            containerNodeField.setAccessible(true);
        }
        Node node = (Node)containerNodeField.get(containerDef);
        Map properties = containerDef.getContainerProperties();
        ChameleonConfiguration configuration = new ChameleonConfiguration();
        try {
            this.setAndRemoveProperties(node, properties, configuration);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure Chameleon container " + setup.getContainerName(), e);
        }
        container.init(configuration, (ContainerDef)containerDef);
    }

    private void setAndRemoveProperties(Node node, Map<String, String> properties, ChameleonConfiguration configuration) throws Exception {
        for (Method setter : configuration.getClass().getMethods()) {
            String propertyName;
            if (!setter.getName().startsWith("set") || !setter.getReturnType().equals(Void.TYPE) || setter.getParameterTypes().length != 1 || !properties.containsKey(propertyName = this.toCamelCase(setter))) continue;
            setter.invoke((Object)configuration, properties.get(propertyName));
            node.getSingle("configuration").removeChild("property@name=" + propertyName);
        }
    }

    private String toCamelCase(Method setter) {
        return new StringBuilder(setter.getName()).replace(0, 4, String.valueOf(Character.toLowerCase(setter.getName().charAt(3)))).toString();
    }
}

