/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.arquillian.container.spi.ConfigurationException;

class FileUtils {
    FileUtils() {
    }

    static InputStream loadConfiguration(String resourceName, boolean isDefault) {
        InputStream stream = FileUtils.loadResource(resourceName);
        if (stream == null) {
            if (isDefault) {
                throw new IllegalStateException("Could not find built-in configuration as file nor classloader resource: " + resourceName + ". " + "Something is terrible wrong with the Classpath.");
            }
            throw new ConfigurationException("Could not locate configured containerConfigurationFile as file nor classloader resource: " + resourceName);
        }
        return stream;
    }

    private static InputStream loadResource(String resourceName) {
        InputStream stream = FileUtils.loadClassPathResource(resourceName);
        if (stream == null) {
            stream = FileUtils.loadFileResource(resourceName);
        }
        return stream;
    }

    private static InputStream loadFileResource(String resourceName) {
        File file = new File(resourceName);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Configuration file could not be found, " + resourceName);
            }
        }
        return null;
    }

    private static InputStream loadClassPathResource(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(resourceName);
    }
}

