/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.controller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.arquillian.container.chameleon.Utils;
import org.arquillian.container.chameleon.spi.model.ContainerAdapter;
import org.arquillian.container.chameleon.spi.model.Target;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class DistributionController {
    private ContainerAdapter targetAdapter;
    private String distributionDownloadFolder;

    public DistributionController(ContainerAdapter targetAdapter, String distributionDownloadFolder) {
        this.targetAdapter = targetAdapter;
        this.distributionDownloadFolder = distributionDownloadFolder;
    }

    public void setup(ContainerDef targetConfiguration, ExecutorService executor) throws Exception {
        if (this.requireDistribution(targetConfiguration)) {
            this.updateTargetConfiguration(targetConfiguration, this.resolveDistribution(executor));
        }
    }

    private boolean requireDistribution(ContainerDef targetConfiguration) {
        return this.targetAdapter.requireDistribution() && this.requiredConfigurationNotSet(targetConfiguration, this.targetAdapter) && (this.targetAdapter.type() == Target.Type.Embedded || this.targetAdapter.type() == Target.Type.Managed);
    }

    private File resolveDistribution(ExecutorService executor) {
        final MavenCoordinate distributableCoordinate = Utils.toMavenCoordinate(this.targetAdapter.distribution());
        if (distributableCoordinate != null) {
            final File targetDirectory = new File(new File(this.distributionDownloadFolder, "server"), distributableCoordinate.getArtifactId() + "_" + distributableCoordinate.getVersion());
            if (targetDirectory.exists()) {
                return this.getDistributionHome(targetDirectory);
            }
            targetDirectory.mkdirs();
            System.out.println("chameleon: preparing distribution " + distributableCoordinate.toCanonicalForm());
            Future uncompressDirectory = executor.submit((Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ((ExplodedExporter)((GenericArchive)((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(distributableCoordinate.toCanonicalForm())).withoutTransitivity()).asSingle(GenericArchive.class)).as(ExplodedExporter.class)).exportExploded(targetDirectory, ".");
                }
            });
            try {
                while (!uncompressDirectory.isDone()) {
                    System.out.print(".");
                    Thread.sleep(500L);
                }
                System.out.println();
                return this.getDistributionHome((File)uncompressDirectory.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void updateTargetConfiguration(ContainerDef targetConfiguration, File distributionHome) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("dist", distributionHome.getAbsolutePath());
        for (Map.Entry<String, String> configuration : this.targetAdapter.resolveConfiguration(values).entrySet()) {
            targetConfiguration.overrideProperty(configuration.getKey(), configuration.getValue());
        }
    }

    private boolean requiredConfigurationNotSet(ContainerDef targetConfiguration, ContainerAdapter adapter) {
        String[] configurationKeys = adapter.configurationKeys();
        Map targetProperties = targetConfiguration.getContainerProperties();
        for (String key : configurationKeys) {
            if (targetProperties.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private File getDistributionHome(File uncompressDirectory) {
        File[] currentDirectoryContent = uncompressDirectory.listFiles();
        if (currentDirectoryContent.length == 1 && currentDirectoryContent[0].isDirectory()) {
            return currentDirectoryContent[0];
        }
        return uncompressDirectory;
    }
}

