/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.spi.model;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.container.chameleon.spi.model.Adapter;
import org.arquillian.container.chameleon.spi.model.Dist;
import org.arquillian.container.chameleon.spi.model.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerAdapter {
    private String version;
    private Target.Type targetType;
    private Adapter adapter;
    private Dist dist;
    private String[] gavExcludeExpression;

    public ContainerAdapter(String version, Target.Type targetType, Adapter adapter, Dist dist, String[] gavExcludeExpression) {
        this.version = version;
        this.targetType = targetType;
        this.adapter = adapter;
        this.dist = dist;
        this.gavExcludeExpression = gavExcludeExpression;
    }

    public Target.Type type() {
        return this.targetType;
    }

    public String adapterClass() {
        return this.adapter.adapterClass();
    }

    public String[] dependencies() {
        return this.resolve(this.adapter.dependencies());
    }

    public String distribution() {
        return this.resolve(this.dist.gav());
    }

    public String[] excludes() {
        return this.resolve(this.gavExcludeExpression);
    }

    public String[] configurationKeys() {
        return this.adapter.configuration().keySet().toArray(new String[0]);
    }

    public boolean requireDistribution() {
        return this.adapter.requireDist();
    }

    public Map<String, String> resolveConfiguration(Map<String, String> parameters) {
        Map<String, String> configuration = this.adapter.configuration();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                entry.setValue(this.resolve(parameter.getKey(), parameter.getValue(), entry.getValue()));
            }
        }
        return configuration;
    }

    private String[] resolve(String[] values) {
        if (values == null) {
            return new String[0];
        }
        String[] resolved = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            resolved[i] = this.resolve(values[i]);
        }
        return resolved;
    }

    private String resolve(String value) {
        return this.resolve("version", this.version, value);
    }

    private String resolve(String parameter, String value, String target) {
        return target.replaceAll(Pattern.quote("${" + parameter + "}"), Matcher.quoteReplacement(value));
    }
}

