/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.controller;

import java.io.File;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import org.arquillian.container.chameleon.ChameleonContainer;
import org.arquillian.container.chameleon.Utils;
import org.arquillian.container.chameleon.controller.Resolver;
import org.arquillian.container.chameleon.spi.model.ContainerAdapter;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetController {
    private ClassLoader classloader;
    private DeployableContainer delegate;

    public TargetController(ContainerAdapter adapter, Injector injector, File resolverCacheFolder) throws Exception {
        this.classloader = this.resolveClasspathDependencies(adapter, resolverCacheFolder);
        Class<?> delegateClass = this.classloader.loadClass(adapter.adapterClass());
        this.delegate = (DeployableContainer)delegateClass.newInstance();
        injector.inject((Object)this.delegate);
    }

    public Class<ContainerConfiguration> getConfigurationClass() {
        return this.delegate.getConfigurationClass();
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setup(final ContainerConfiguration configuration) throws LifecycleException {
        this.lifecycle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.setup(configuration);
                return null;
            }
        });
    }

    public void start() throws LifecycleException {
        this.lifecycle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.start();
                return null;
            }
        });
    }

    public void stop() throws LifecycleException {
        this.lifecycle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.stop();
                return null;
            }
        });
    }

    public ProtocolMetaData deploy(final Archive<?> archive) throws DeploymentException {
        return this.deployment(new Callable<ProtocolMetaData>(){

            @Override
            public ProtocolMetaData call() throws Exception {
                return TargetController.this.delegate.deploy(archive);
            }
        });
    }

    public void undeploy(final Archive<?> archive) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.undeploy(archive);
                return null;
            }
        });
    }

    public void deploy(final Descriptor descriptor) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.deploy(descriptor);
                return null;
            }
        });
    }

    public void undeploy(final Descriptor descriptor) throws DeploymentException {
        this.deployment(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TargetController.this.delegate.undeploy(descriptor);
                return null;
            }
        });
    }

    private <T> T deployment(Callable<T> callable) throws DeploymentException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            T t = callable.call();
            return t;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Could not proxy call", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private <T> T lifecycle(Callable<T> callable) throws LifecycleException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            T t = callable.call();
            return t;
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LifecycleException("Could not proxy call", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private ClassLoader resolveClasspathDependencies(ContainerAdapter targetAdapter, File resolverCacheFolder) {
        String[] dependencies = targetAdapter.dependencies();
        try {
            MavenDependency[] mavenDependencies = Utils.toMavenDependencies(dependencies, targetAdapter.excludes());
            File[] archives = Resolver.resolve(resolverCacheFolder, mavenDependencies);
            return new URLClassLoader(Utils.toURLs(archives), ChameleonContainer.class.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve target " + targetAdapter + " adapter dependencies", e);
        }
    }
}

