/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.archive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.archive.UncompressTool;

public class UntarTool
extends UncompressTool {
    private Compression compression = Compression.GZIP;

    public UntarTool gzip(boolean isGzip) {
        this.compression = isGzip ? Compression.GZIP : Compression.NONE;
        return this;
    }

    public UntarTool bzip2(boolean isBZip2) {
        this.compression = isBZip2 ? Compression.BZIP2 : Compression.NONE;
        return this;
    }

    @Override
    protected ArchiveInputStream compressedInputStream(InputStream compressedFile) {
        BufferedInputStream in = new BufferedInputStream(compressedFile);
        return this.compression.wrap(in);
    }

    @Override
    protected int permissionsMode(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof TarArchiveEntry) {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
            return tarArchiveEntry.getMode();
        }
        throw new ExecutionException("No TarEntry has been passed to a Tar method.", new Object[0]);
    }

    private static enum Compression {
        GZIP{

            @Override
            public ArchiveInputStream wrap(BufferedInputStream input) {
                try {
                    GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)input);
                    return new TarArchiveInputStream((InputStream)gzIn);
                }
                catch (IOException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
        }
        ,
        BZIP2{

            @Override
            public ArchiveInputStream wrap(BufferedInputStream input) {
                try {
                    BZip2CompressorInputStream bzip2 = new BZip2CompressorInputStream((InputStream)input);
                    return new TarArchiveInputStream((InputStream)bzip2);
                }
                catch (IOException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
        }
        ,
        NONE{

            @Override
            public ArchiveInputStream wrap(BufferedInputStream input) {
                return new TarArchiveInputStream((InputStream)input);
            }
        };


        public abstract ArchiveInputStream wrap(BufferedInputStream var1);
    }
}

