/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

public class BodyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final RandomAccessBody body;
    private long transferred;

    public BodyFileRegion(RandomAccessBody body) {
        this.body = Assertions.assertNotNull(body, "body");
    }

    @Override
    public long position() {
        return 0L;
    }

    @Override
    public long count() {
        return this.body.getContentLength();
    }

    @Override
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long written = this.body.transferTo(target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    protected void deallocate() {
        MiscUtils.closeSilently(this.body);
    }
}

