/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.request.body.multipart.PartBase;
import org.asynchttpclient.util.Assertions;

public class StringPart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private final String value;

    private static Charset charsetOrDefault(Charset charset) {
        return charset == null ? DEFAULT_CHARSET : charset;
    }

    private static String contentTypeOrDefault(String contentType) {
        return contentType == null ? DEFAULT_CONTENT_TYPE : contentType;
    }

    private static String transferEncodingOrDefault(String transferEncoding) {
        return transferEncoding == null ? DEFAULT_TRANSFER_ENCODING : transferEncoding;
    }

    public StringPart(String name, String value) {
        this(name, value, null);
    }

    public StringPart(String name, String value, String contentType) {
        this(name, value, contentType, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset) {
        this(name, value, contentType, charset, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset, String contentId) {
        this(name, value, contentType, charset, contentId, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset, String contentId, String transferEncoding) {
        super(name, StringPart.contentTypeOrDefault(contentType), StringPart.charsetOrDefault(charset), contentId, StringPart.transferEncodingOrDefault(transferEncoding));
        Assertions.assertNotNull(value, "value");
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

