/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.ReadTimeoutTimerTask;
import org.asynchttpclient.netty.timeout.RequestTimeoutTimerTask;
import org.asynchttpclient.util.DateUtils;

public class TimeoutsHolder {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;
    private final long requestTimeoutMillisTime;
    private final int readTimeoutValue;
    private volatile NettyResponseFuture<?> nettyResponseFuture;
    public final Timeout requestTimeout;
    public volatile Timeout readTimeout;
    private volatile String remoteAddress = "not-connected";

    public TimeoutsHolder(Timer nettyTimer, NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, AsyncHttpClientConfig config) {
        this.nettyTimer = nettyTimer;
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.readTimeoutValue = config.getReadTimeout();
        int requestTimeoutInMs = nettyResponseFuture.getTargetRequest().getRequestTimeout();
        if (requestTimeoutInMs == 0) {
            requestTimeoutInMs = config.getRequestTimeout();
        }
        if (requestTimeoutInMs != -1) {
            this.requestTimeoutMillisTime = DateUtils.millisTime() + (long)requestTimeoutInMs;
            this.requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, requestSender, this, requestTimeoutInMs), requestTimeoutInMs);
        } else {
            this.requestTimeoutMillisTime = -1L;
            this.requestTimeout = null;
        }
    }

    private void initRemoteAddress() {
        SocketAddress sa;
        Channel channel = this.nettyResponseFuture.channel();
        if (channel != null && (sa = channel.remoteAddress()) != null) {
            this.remoteAddress = sa.toString();
        }
    }

    public void startReadTimeout() {
        this.initRemoteAddress();
        if (this.readTimeoutValue != -1) {
            this.startReadTimeout(null);
        }
    }

    void startReadTimeout(ReadTimeoutTimerTask task) {
        if (this.requestTimeout == null || !this.requestTimeout.isExpired() && (long)this.readTimeoutValue > this.requestTimeoutMillisTime - DateUtils.millisTime()) {
            Timeout readTimeout;
            if (task == null) {
                task = new ReadTimeoutTimerTask(this.nettyResponseFuture, this.requestSender, this, this.readTimeoutValue);
            }
            this.readTimeout = readTimeout = this.newTimeout(task, this.readTimeoutValue);
        } else if (task != null) {
            task.clean();
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel();
                ((RequestTimeoutTimerTask)RequestTimeoutTimerTask.class.cast(this.requestTimeout.task())).clean();
            }
            if (this.readTimeout != null) {
                this.readTimeout.cancel();
                ((ReadTimeoutTimerTask)ReadTimeoutTimerTask.class.cast(this.readTimeout.task())).clean();
            }
        }
    }

    private Timeout newTimeout(TimerTask task, long delay) {
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }

    String remoteAddress() {
        return this.remoteAddress;
    }
}

