/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyServerSelector;
import org.asynchttpclient.util.PrefixIncrementThreadFactory;
import org.asynchttpclient.util.ProxyUtils;

public class AsyncHttpClientConfig {
    public static final String AHC_VERSION;
    protected String name;
    protected int connectTimeout;
    protected int maxConnections;
    protected int maxConnectionsPerHost;
    protected int requestTimeout;
    protected int readTimeout;
    protected int webSocketTimeout;
    protected boolean allowPoolingConnections;
    protected boolean allowPoolingSslConnections;
    protected int pooledConnectionIdleTimeout;
    protected int connectionTTL;
    protected SSLContext sslContext;
    protected boolean acceptAnyCertificate;
    protected boolean followRedirect;
    protected int maxRedirects;
    protected boolean strict302Handling;
    protected ProxyServerSelector proxyServerSelector;
    protected boolean compressionEnforced;
    protected String userAgent;
    protected ExecutorService executorService;
    protected Realm realm;
    protected List<RequestFilter> requestFilters;
    protected List<ResponseFilter> responseFilters;
    protected List<IOExceptionFilter> ioExceptionFilters;
    protected int maxRequestRetry;
    protected boolean disableUrlEncodingForBoundRequests;
    protected int ioThreadMultiplier;
    protected String[] enabledProtocols;
    protected String[] enabledCipherSuites;
    protected Integer sslSessionCacheSize;
    protected Integer sslSessionTimeout;
    protected int httpClientCodecMaxInitialLineLength = 4096;
    protected int httpClientCodecMaxHeaderSize = 8192;
    protected int httpClientCodecMaxChunkSize = 8192;
    protected boolean disableZeroCopy;
    protected long handshakeTimeout = 10000L;
    protected SSLEngineFactory sslEngineFactory;
    protected int chunkedFileChunkSize = 8192;
    protected int webSocketMaxBufferSize = 128000000;
    protected int webSocketMaxFrameSize = 10240;
    protected boolean keepEncodingHeader = false;
    protected int shutdownQuiet = 2000;
    protected int shutdownTimeout = 15000;
    protected AdvancedConfig advancedConfig;

    protected AsyncHttpClientConfig() {
    }

    private AsyncHttpClientConfig(String name, int connectTimeout, int maxConnections, int maxConnectionsPerHost, int requestTimeout, int readTimeout, int webSocketTimeout, boolean allowPoolingConnection, boolean allowSslConnectionPool, int idleConnectionInPoolTimeout, int maxConnectionLifeTime, SSLContext sslContext, boolean acceptAnyCertificate, boolean followRedirect, int maxRedirects, boolean strict302Handling, ExecutorService executorService, ProxyServerSelector proxyServerSelector, boolean compressionEnforced, String userAgent, Realm realm, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, int maxRequestRetry, boolean disableUrlEncodingForBoundRequests, int ioThreadMultiplier, String[] enabledProtocols, String[] enabledCipherSuites, Integer sslSessionCacheSize, Integer sslSessionTimeout, int httpClientCodecMaxInitialLineLength, int httpClientCodecMaxHeaderSize, int httpClientCodecMaxChunkSize, boolean disableZeroCopy, long handshakeTimeout, SSLEngineFactory sslEngineFactory, int chunkedFileChunkSize, int webSocketMaxBufferSize, int webSocketMaxFrameSize, boolean keepEncodingHeader, int shutdownQuiet, int shutdownTimeout, AdvancedConfig advancedConfig) {
        this.name = name;
        this.connectTimeout = connectTimeout;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.webSocketTimeout = webSocketTimeout;
        this.allowPoolingConnections = allowPoolingConnection;
        this.allowPoolingSslConnections = allowSslConnectionPool;
        this.pooledConnectionIdleTimeout = idleConnectionInPoolTimeout;
        this.connectionTTL = maxConnectionLifeTime;
        this.sslContext = sslContext;
        this.acceptAnyCertificate = acceptAnyCertificate;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.strict302Handling = strict302Handling;
        this.proxyServerSelector = proxyServerSelector;
        this.compressionEnforced = compressionEnforced;
        this.userAgent = userAgent;
        if (executorService != null) {
            this.executorService = executorService;
        } else {
            PrefixIncrementThreadFactory threadFactory = new PrefixIncrementThreadFactory(this.getNameOrDefault() + "-");
            this.executorService = Executors.newCachedThreadPool(threadFactory);
        }
        this.realm = realm;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.maxRequestRetry = maxRequestRetry;
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
        this.ioThreadMultiplier = ioThreadMultiplier;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
        this.sslSessionCacheSize = sslSessionCacheSize;
        this.sslSessionTimeout = sslSessionTimeout;
        this.advancedConfig = advancedConfig;
        this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
        this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
        this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
        this.disableZeroCopy = disableZeroCopy;
        this.handshakeTimeout = handshakeTimeout;
        this.sslEngineFactory = sslEngineFactory;
        this.chunkedFileChunkSize = chunkedFileChunkSize;
        this.webSocketMaxBufferSize = webSocketMaxBufferSize;
        this.webSocketMaxFrameSize = webSocketMaxFrameSize;
        this.keepEncodingHeader = keepEncodingHeader;
        this.shutdownQuiet = shutdownQuiet;
        this.shutdownTimeout = shutdownTimeout;
    }

    public String getName() {
        return this.name;
    }

    public String getNameOrDefault() {
        String r = this.name;
        if (r == null || r.isEmpty()) {
            r = AsyncHttpClientConfigDefaults.defaultName();
        }
        if (r == null || r.isEmpty()) {
            r = "AsyncHttpClient";
        }
        return r;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWebSocketTimeout() {
        return this.webSocketTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getPooledConnectionIdleTimeout() {
        return this.pooledConnectionIdleTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAllowPoolingConnections() {
        return this.allowPoolingConnections;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isCompressionEnforced() {
        return this.compressionEnforced;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ProxyServerSelector getProxyServerSelector() {
        return this.proxyServerSelector;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public AdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public boolean hasRequestFilters() {
        return !this.requestFilters.isEmpty();
    }

    public List<RequestFilter> getRequestFilters() {
        return Collections.unmodifiableList(this.requestFilters);
    }

    public boolean hasResponseFilters() {
        return !this.responseFilters.isEmpty();
    }

    public List<ResponseFilter> getResponseFilters() {
        return Collections.unmodifiableList(this.responseFilters);
    }

    public List<IOExceptionFilter> getIOExceptionFilters() {
        return Collections.unmodifiableList(this.ioExceptionFilters);
    }

    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    public boolean isAllowPoolingSslConnections() {
        return this.allowPoolingSslConnections;
    }

    public boolean isDisableUrlEncodingForBoundRequests() {
        return this.disableUrlEncodingForBoundRequests;
    }

    public boolean isValid() {
        boolean atpRunning = true;
        try {
            atpRunning = this.executorService.isShutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return atpRunning;
    }

    public int getIoThreadMultiplier() {
        return this.ioThreadMultiplier;
    }

    public boolean isStrict302Handling() {
        return this.strict302Handling;
    }

    public int getConnectionTTL() {
        return this.connectionTTL;
    }

    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public Integer getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public Integer getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public int getHttpClientCodecMaxInitialLineLength() {
        return this.httpClientCodecMaxInitialLineLength;
    }

    public int getHttpClientCodecMaxHeaderSize() {
        return this.httpClientCodecMaxHeaderSize;
    }

    public int getHttpClientCodecMaxChunkSize() {
        return this.httpClientCodecMaxChunkSize;
    }

    public boolean isDisableZeroCopy() {
        return this.disableZeroCopy;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public SSLEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }

    public int getChunkedFileChunkSize() {
        return this.chunkedFileChunkSize;
    }

    public int getWebSocketMaxBufferSize() {
        return this.webSocketMaxBufferSize;
    }

    public int getWebSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    public boolean isKeepEncodingHeader() {
        return this.keepEncodingHeader;
    }

    public int getShutdownQuiet() {
        return this.shutdownQuiet;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    static {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = AsyncHttpClientConfig.class.getResourceAsStream("/ahc-version.properties");
            prop.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        AHC_VERSION = prop.getProperty("ahc.version", "UNKNOWN");
    }

    public static class Builder {
        private String name = AsyncHttpClientConfigDefaults.defaultName();
        private int connectTimeout = AsyncHttpClientConfigDefaults.defaultConnectTimeout();
        private int maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        private int maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        private int requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        private int readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        private int webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        private boolean allowPoolingConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnections();
        private boolean allowPoolingSslConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingSslConnections();
        private int pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        private int connectionTTL = AsyncHttpClientConfigDefaults.defaultConnectionTTL();
        private SSLContext sslContext;
        private boolean acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        private boolean followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        private int maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        private boolean strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        private ProxyServerSelector proxyServerSelector = null;
        private boolean useProxySelector = AsyncHttpClientConfigDefaults.defaultUseProxySelector();
        private boolean useProxyProperties = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
        private boolean compressionEnforced = AsyncHttpClientConfigDefaults.defaultCompressionEnforced();
        private String userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        private ExecutorService applicationThreadPool;
        private Realm realm;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private int maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        private boolean disableUrlEncodingForBoundRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        private int ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        private String[] enabledProtocols = AsyncHttpClientConfigDefaults.defaultEnabledProtocols();
        private String[] enabledCipherSuites;
        private Integer sslSessionCacheSize = AsyncHttpClientConfigDefaults.defaultSslSessionCacheSize();
        private Integer sslSessionTimeout = AsyncHttpClientConfigDefaults.defaultSslSessionTimeout();
        private int httpClientCodecMaxInitialLineLength = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxInitialLineLength();
        private int httpClientCodecMaxHeaderSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxHeaderSize();
        private int httpClientCodecMaxChunkSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxChunkSize();
        private boolean disableZeroCopy = AsyncHttpClientConfigDefaults.defaultDisableZeroCopy();
        private long handshakeTimeout = AsyncHttpClientConfigDefaults.defaultHandshakeTimeout();
        private SSLEngineFactory sslEngineFactory;
        private int chunkedFileChunkSize = AsyncHttpClientConfigDefaults.defaultChunkedFileChunkSize();
        private int webSocketMaxBufferSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxBufferSize();
        private int webSocketMaxFrameSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxFrameSize();
        private boolean keepEncodingHeader = AsyncHttpClientConfigDefaults.defaultKeepEncodingHeader();
        private int shutdownQuiet = AsyncHttpClientConfigDefaults.defaultShutdownQuiet();
        private int shutdownTimeout = AsyncHttpClientConfigDefaults.defaultShutdownTimeout();
        private AdvancedConfig advancedConfig;

        public Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setWebSocketTimeout(int webSocketTimeout) {
            this.webSocketTimeout = webSocketTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder setCompressionEnforced(boolean compressionEnforced) {
            this.compressionEnforced = compressionEnforced;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setAllowPoolingConnections(boolean allowPoolingConnections) {
            this.allowPoolingConnections = allowPoolingConnections;
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            this.applicationThreadPool = applicationThreadPool;
            return this;
        }

        public Builder setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
            this.proxyServerSelector = proxyServerSelector;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
            return this;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAdvancedConfig(AdvancedConfig advancedConfig) {
            this.advancedConfig = advancedConfig;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setAllowPoolingSslConnections(boolean allowPoolingSslConnections) {
            this.allowPoolingSslConnections = allowPoolingSslConnections;
            return this;
        }

        public Builder setDisableUrlEncodingForBoundRequests(boolean disableUrlEncodingForBoundRequests) {
            this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
            return this;
        }

        public Builder setUseProxySelector(boolean useProxySelector) {
            this.useProxySelector = useProxySelector;
            return this;
        }

        public Builder setUseProxyProperties(boolean useProxyProperties) {
            this.useProxyProperties = useProxyProperties;
            return this;
        }

        public Builder setIOThreadMultiplier(int multiplier) {
            this.ioThreadMultiplier = multiplier;
            return this;
        }

        public Builder setStrict302Handling(boolean strict302Handling) {
            this.strict302Handling = strict302Handling;
            return this;
        }

        public Builder setConnectionTTL(int connectionTTL) {
            this.connectionTTL = connectionTTL;
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.acceptAnyCertificate = acceptAnyCertificate;
            return this;
        }

        public Builder setEnabledProtocols(String[] enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public Builder setEnabledCipherSuites(String[] enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public Builder setSslSessionCacheSize(Integer sslSessionCacheSize) {
            this.sslSessionCacheSize = sslSessionCacheSize;
            return this;
        }

        public Builder setSslSessionTimeout(Integer sslSessionTimeout) {
            this.sslSessionTimeout = sslSessionTimeout;
            return this;
        }

        public Builder setHttpClientCodecMaxInitialLineLength(int httpClientCodecMaxInitialLineLength) {
            this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
            return this;
        }

        public Builder setHttpClientCodecMaxHeaderSize(int httpClientCodecMaxHeaderSize) {
            this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
            return this;
        }

        public Builder setHttpClientCodecMaxChunkSize(int httpClientCodecMaxChunkSize) {
            this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
            return this;
        }

        public Builder setDisableZeroCopy(boolean disableZeroCopy) {
            this.disableZeroCopy = disableZeroCopy;
            return this;
        }

        public Builder setHandshakeTimeout(long handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        public Builder setSslEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
            return this;
        }

        public Builder setChunkedFileChunkSize(int chunkedFileChunkSize) {
            this.chunkedFileChunkSize = chunkedFileChunkSize;
            return this;
        }

        public Builder setWebSocketMaxBufferSize(int webSocketMaxBufferSize) {
            this.webSocketMaxBufferSize = webSocketMaxBufferSize;
            return this;
        }

        public Builder setWebSocketMaxFrameSize(int webSocketMaxFrameSize) {
            this.webSocketMaxFrameSize = webSocketMaxFrameSize;
            return this;
        }

        public Builder setKeepEncodingHeader(boolean keepEncodingHeader) {
            this.keepEncodingHeader = keepEncodingHeader;
            return this;
        }

        public Builder setShutdownQuiet(int shutdownQuiet) {
            this.shutdownQuiet = shutdownQuiet;
            return this;
        }

        public Builder setShutdownTimeout(int shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public Builder(AsyncHttpClientConfig prototype) {
            this.name = prototype.getName();
            this.allowPoolingConnections = prototype.isAllowPoolingConnections();
            this.connectTimeout = prototype.getConnectTimeout();
            this.pooledConnectionIdleTimeout = prototype.getPooledConnectionIdleTimeout();
            this.readTimeout = prototype.getReadTimeout();
            this.maxConnectionsPerHost = prototype.getMaxConnectionsPerHost();
            this.connectionTTL = prototype.getConnectionTTL();
            this.maxRedirects = prototype.getMaxRedirects();
            this.maxConnections = prototype.getMaxConnections();
            this.proxyServerSelector = prototype.getProxyServerSelector();
            this.realm = prototype.getRealm();
            this.requestTimeout = prototype.getRequestTimeout();
            this.sslContext = prototype.getSSLContext();
            this.userAgent = prototype.getUserAgent();
            this.followRedirect = prototype.isFollowRedirect();
            this.compressionEnforced = prototype.isCompressionEnforced();
            this.applicationThreadPool = prototype.getExecutorService();
            this.requestFilters.clear();
            this.responseFilters.clear();
            this.ioExceptionFilters.clear();
            this.requestFilters.addAll(prototype.getRequestFilters());
            this.responseFilters.addAll(prototype.getResponseFilters());
            this.ioExceptionFilters.addAll(prototype.getIOExceptionFilters());
            this.disableUrlEncodingForBoundRequests = prototype.isDisableUrlEncodingForBoundRequests();
            this.ioThreadMultiplier = prototype.getIoThreadMultiplier();
            this.maxRequestRetry = prototype.getMaxRequestRetry();
            this.allowPoolingSslConnections = prototype.isAllowPoolingConnections();
            this.strict302Handling = prototype.isStrict302Handling();
            this.acceptAnyCertificate = prototype.acceptAnyCertificate;
            this.enabledProtocols = prototype.enabledProtocols;
            this.enabledCipherSuites = prototype.enabledCipherSuites;
            this.sslSessionCacheSize = prototype.sslSessionCacheSize;
            this.sslSessionTimeout = prototype.sslSessionTimeout;
            this.httpClientCodecMaxInitialLineLength = prototype.httpClientCodecMaxInitialLineLength;
            this.httpClientCodecMaxHeaderSize = prototype.httpClientCodecMaxHeaderSize;
            this.httpClientCodecMaxChunkSize = prototype.httpClientCodecMaxChunkSize;
            this.disableZeroCopy = prototype.disableZeroCopy;
            this.handshakeTimeout = prototype.handshakeTimeout;
            this.sslEngineFactory = prototype.sslEngineFactory;
            this.chunkedFileChunkSize = prototype.chunkedFileChunkSize;
            this.webSocketMaxBufferSize = prototype.webSocketMaxBufferSize;
            this.webSocketMaxFrameSize = prototype.webSocketMaxFrameSize;
            this.keepEncodingHeader = prototype.keepEncodingHeader;
            this.shutdownQuiet = prototype.shutdownQuiet;
            this.shutdownTimeout = prototype.shutdownTimeout;
            this.advancedConfig = prototype.advancedConfig;
        }

        public AsyncHttpClientConfig build() {
            if (this.proxyServerSelector == null && this.useProxySelector) {
                this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
            }
            if (this.proxyServerSelector == null && this.useProxyProperties) {
                this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
            }
            if (this.proxyServerSelector == null) {
                this.proxyServerSelector = ProxyServerSelector.NO_PROXY_SELECTOR;
            }
            return new AsyncHttpClientConfig(this.name, this.connectTimeout, this.maxConnections, this.maxConnectionsPerHost, this.requestTimeout, this.readTimeout, this.webSocketTimeout, this.allowPoolingConnections, this.allowPoolingSslConnections, this.pooledConnectionIdleTimeout, this.connectionTTL, this.sslContext, this.acceptAnyCertificate, this.followRedirect, this.maxRedirects, this.strict302Handling, this.applicationThreadPool, this.proxyServerSelector, this.compressionEnforced, this.userAgent, this.realm, this.requestFilters, this.responseFilters, this.ioExceptionFilters, this.maxRequestRetry, this.disableUrlEncodingForBoundRequests, this.ioThreadMultiplier, this.enabledProtocols, this.enabledCipherSuites, this.sslSessionCacheSize, this.sslSessionTimeout, this.httpClientCodecMaxInitialLineLength, this.httpClientCodecMaxHeaderSize, this.httpClientCodecMaxChunkSize, this.disableZeroCopy, this.handshakeTimeout, this.sslEngineFactory, this.chunkedFileChunkSize, this.webSocketMaxBufferSize, this.webSocketMaxFrameSize, this.keepEncodingHeader, this.shutdownQuiet, this.shutdownTimeout, this.advancedConfig);
        }
    }
}

