/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncHttpClient
implements AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    protected SignatureCalculator signatureCalculator;

    public DefaultAsyncHttpClient() {
        this(new AsyncHttpClientConfig.Builder().build());
    }

    public DefaultAsyncHttpClient(AsyncHttpClientConfig config) {
        this.config = config;
        AdvancedConfig advancedConfig = config.getAdvancedConfig() != null ? config.getAdvancedConfig() : new AdvancedConfig();
        this.allowStopNettyTimer = advancedConfig.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : advancedConfig.getNettyTimer();
        this.channelManager = new ChannelManager(config, advancedConfig, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, this.closed);
        this.channelManager.configureBootstraps(this.requestSender);
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
                if (this.allowStopNettyTimer) {
                    this.nettyTimer.stop();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on close", t);
            }
        }
    }

    @Override
    public void closeAsynchronously() {
        final ExecutorService e = Executors.newSingleThreadExecutor();
        e.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultAsyncHttpClient.this.close();
                }
                catch (Throwable t) {
                    LOGGER.warn("", t);
                }
                finally {
                    e.shutdown();
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed.get()) {
                LOGGER.error("AsyncHttpClient.close() hasn't been invoked, which may produce file descriptor leaks");
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DefaultAsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    @Override
    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    @Override
    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    @Override
    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    @Override
    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    @Override
    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    @Override
    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    @Override
    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    @Override
    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder("PATCH", url);
    }

    @Override
    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder("TRACE", url);
    }

    @Override
    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        if (this.config.getRequestFilters().isEmpty()) {
            return this.execute(request, handler);
        }
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, new AsyncCompletionHandlerBase());
    }

    private <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request, asyncHandler, null, false);
        }
        catch (Exception e) {
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            if (fc != null) continue;
            throw new NullPointerException("FilterContext is null");
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = new RequestBuilder(request);
            builder.setHeader("Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request).build();
        return fc;
    }

    public ChannelPool getChannelPool() {
        return this.channelManager.getChannelPool();
    }

    protected BoundRequestBuilder requestBuilder(String method, String url) {
        return (BoundRequestBuilder)((BoundRequestBuilder)new BoundRequestBuilder(this, method, this.config.isDisableUrlEncodingForBoundRequests()).setUrl(url)).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return (BoundRequestBuilder)new BoundRequestBuilder(this, prototype).setSignatureCalculator(this.signatureCalculator);
    }
}

