/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import java.nio.CharBuffer;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieDecoder.class);

    public static Cookie decode(String header) {
        char c;
        if (header == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header.length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            int valueEnd;
            int valueStart;
            int nameEnd;
            int nameBegin;
            block15: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                nameEnd = i;
                valueStart = -1;
                valueEnd = -1;
                if (i != headerLen) {
                    do {
                        char curChar;
                        if ((curChar = header.charAt(i)) == ';') {
                            nameEnd = i;
                            valueEnd = -1;
                            valueStart = -1;
                        } else {
                            if (curChar != '=') continue;
                            nameEnd = i++;
                            if (i == headerLen) {
                                valueEnd = 0;
                                valueStart = 0;
                            } else {
                                valueStart = i;
                                int semiPos = header.indexOf(59, i);
                                i = semiPos > 0 ? semiPos : headerLen;
                                valueEnd = i;
                            }
                        }
                        break block15;
                    } while (++i != headerLen);
                    nameEnd = headerLen;
                    valueEnd = -1;
                    valueStart = -1;
                }
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                if (nameBegin == -1 || nameBegin == nameEnd) {
                    LOGGER.debug("Skipping cookie with null name");
                    return null;
                }
                if (valueStart == -1) {
                    LOGGER.debug("Skipping cookie with null value");
                    return null;
                }
                CharBuffer wrappedValue = CharBuffer.wrap(header, valueStart, valueEnd);
                CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
                if (unwrappedValue == null) {
                    LOGGER.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)unwrappedValue);
                    return null;
                }
                String name = header.substring(nameBegin, nameEnd);
                boolean wrap = unwrappedValue.length() != valueEnd - valueStart;
                cookieBuilder = new CookieBuilder(name, unwrappedValue.toString(), wrap, header);
                continue;
            }
            cookieBuilder.appendAttribute(nameBegin, nameEnd, valueStart, valueEnd);
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private static final String PATH = "Path";
        private static final String EXPIRES = "Expires";
        private static final String MAX_AGE = "Max-Age";
        private static final String DOMAIN = "Domain";
        private static final String SECURE = "Secure";
        private static final String HTTPONLY = "HTTPOnly";
        private final String name;
        private final String value;
        private final boolean wrap;
        private final String header;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private int expiresStart;
        private int expiresEnd;
        private boolean secure;
        private boolean httpOnly;

        public CookieBuilder(String name, String value, boolean wrap, String header) {
            this.name = name;
            this.value = value;
            this.wrap = wrap;
            this.header = header;
        }

        public Cookie cookie() {
            return new Cookie(this.name, this.value, this.wrap, this.domain, this.path, this.mergeMaxAgeAndExpires(), this.secure, this.httpOnly);
        }

        private long mergeMaxAgeAndExpires() {
            long expiresMillis;
            if (this.maxAge != Long.MIN_VALUE) {
                return this.maxAge;
            }
            String expires = this.computeValue(this.expiresStart, this.expiresEnd);
            if (expires != null && (expiresMillis = CookieUtil.computeExpires(expires)) != Long.MIN_VALUE) {
                long maxAgeMillis = expiresMillis - System.currentTimeMillis();
                return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
            }
            return Long.MIN_VALUE;
        }

        public void appendAttribute(int keyStart, int keyEnd, int valueStart, int valueEnd) {
            this.setCookieAttribute(keyStart, keyEnd, valueStart, valueEnd);
        }

        private void setCookieAttribute(int keyStart, int keyEnd, int valueStart, int valueEnd) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(keyStart, valueStart, valueEnd);
            } else if (length == 6) {
                this.parse6(keyStart, valueStart, valueEnd);
            } else if (length == 7) {
                this.parse7(keyStart, valueStart, valueEnd);
            } else if (length == 8) {
                this.parse8(keyStart, valueStart, valueEnd);
            }
        }

        private void parse4(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, PATH, 0, 4)) {
                this.path = this.computeValue(valueStart, valueEnd);
            }
        }

        private void parse6(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, DOMAIN, 0, 5)) {
                this.domain = this.computeValue(valueStart, valueEnd);
            } else if (this.header.regionMatches(true, nameStart, SECURE, 0, 5)) {
                this.secure = true;
            }
        }

        private void parse7(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, EXPIRES, 0, 7)) {
                this.expiresStart = valueStart;
                this.expiresEnd = valueEnd;
            } else if (this.header.regionMatches(true, nameStart, MAX_AGE, 0, 7)) {
                try {
                    this.maxAge = Math.max(Integer.valueOf(this.computeValue(valueStart, valueEnd)), 0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private void parse8(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, HTTPONLY, 0, 8)) {
                this.httpOnly = true;
            }
        }

        private String computeValue(int valueStart, int valueEnd) {
            if (valueStart == -1 || valueStart == valueEnd) {
                return null;
            }
            while (valueStart < valueEnd && this.header.charAt(valueStart) <= ' ') {
                ++valueStart;
            }
            while (valueStart < valueEnd && this.header.charAt(valueEnd - 1) <= ' ') {
                --valueEnd;
            }
            return valueStart == valueEnd ? null : this.header.substring(valueStart, valueEnd);
        }
    }
}

