/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.webdav.WebDavResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class WebDavCompletionHandlerBase<T>
implements AsyncHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(AsyncCompletionHandlerBase.class);
    private final List<HttpResponseBodyPart> bodies = Collections.synchronizedList(new ArrayList());
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.bodies.add(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        if (this.status != null) {
            Response response = this.status.prepareResponse(this.headers, this.bodies);
            Document document = null;
            if (this.status.getStatusCode() == 207) {
                document = this.readXMLResponse(response.getResponseBodyAsStream());
            }
            return this.onCompleted(new WebDavResponse(this.status.prepareResponse(this.headers, this.bodies), document));
        }
        throw new IllegalStateException("Status is null");
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(WebDavResponse var1) throws Exception;

    private Document readXMLResponse(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = factory.newDocumentBuilder().parse(stream);
            this.parse(document);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return document;
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList statusNode = element.getElementsByTagName("status");
        for (int i = 0; i < statusNode.getLength(); ++i) {
            Node node = statusNode.item(i);
            String value = node.getFirstChild().getNodeValue();
            int statusCode = Integer.valueOf(value.substring(value.indexOf(" "), value.lastIndexOf(" ")).trim());
            String statusText = value.substring(value.lastIndexOf(" "));
            this.status = new HttpStatusWrapper(this.status, statusText, statusCode);
        }
    }

    private class HttpStatusWrapper
    extends HttpResponseStatus {
        private final HttpResponseStatus wrapped;
        private final String statusText;
        private final int statusCode;

        public HttpStatusWrapper(HttpResponseStatus wrapper, String statusText, int statusCode) {
            super(wrapper.getUri(), null);
            this.wrapped = wrapper;
            this.statusText = statusText;
            this.statusCode = statusCode;
        }

        @Override
        public Response prepareResponse(HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
            final Response wrappedResponse = this.wrapped.prepareResponse(headers, bodyParts);
            return new Response(){

                @Override
                public int getStatusCode() {
                    return HttpStatusWrapper.this.statusCode;
                }

                @Override
                public String getStatusText() {
                    return HttpStatusWrapper.this.statusText;
                }

                @Override
                public byte[] getResponseBodyAsBytes() throws IOException {
                    return wrappedResponse.getResponseBodyAsBytes();
                }

                @Override
                public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
                    return wrappedResponse.getResponseBodyAsByteBuffer();
                }

                @Override
                public InputStream getResponseBodyAsStream() throws IOException {
                    return wrappedResponse.getResponseBodyAsStream();
                }

                @Override
                public String getResponseBody(Charset charset) throws IOException {
                    return wrappedResponse.getResponseBody(charset);
                }

                @Override
                public String getResponseBody() throws IOException {
                    return wrappedResponse.getResponseBody();
                }

                @Override
                public Uri getUri() {
                    return wrappedResponse.getUri();
                }

                @Override
                public String getContentType() {
                    return wrappedResponse.getContentType();
                }

                @Override
                public String getHeader(String name) {
                    return wrappedResponse.getHeader(name);
                }

                @Override
                public List<String> getHeaders(String name) {
                    return wrappedResponse.getHeaders(name);
                }

                @Override
                public FluentCaseInsensitiveStringsMap getHeaders() {
                    return wrappedResponse.getHeaders();
                }

                @Override
                public boolean isRedirected() {
                    return wrappedResponse.isRedirected();
                }

                @Override
                public List<Cookie> getCookies() {
                    return wrappedResponse.getCookies();
                }

                @Override
                public boolean hasResponseStatus() {
                    return wrappedResponse.hasResponseStatus();
                }

                @Override
                public boolean hasResponseHeaders() {
                    return wrappedResponse.hasResponseHeaders();
                }

                @Override
                public boolean hasResponseBody() {
                    return wrappedResponse.hasResponseBody();
                }

                @Override
                public SocketAddress getRemoteAddress() {
                    return wrappedResponse.getRemoteAddress();
                }

                @Override
                public SocketAddress getLocalAddress() {
                    return wrappedResponse.getLocalAddress();
                }
            };
        }

        @Override
        public int getStatusCode() {
            return this.statusText == null ? this.wrapped.getStatusCode() : this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText == null ? this.wrapped.getStatusText() : this.statusText;
        }

        @Override
        public String getProtocolName() {
            return this.wrapped.getProtocolName();
        }

        @Override
        public int getProtocolMajorVersion() {
            return this.wrapped.getProtocolMajorVersion();
        }

        @Override
        public int getProtocolMinorVersion() {
            return this.wrapped.getProtocolMinorVersion();
        }

        @Override
        public String getProtocolText() {
            return this.wrapped.getStatusText();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.wrapped.getRemoteAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return this.wrapped.getLocalAddress();
        }
    }
}

