/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.util.Timer;
import java.util.HashMap;
import java.util.Map;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.channel.pool.ConnectionStrategy;
import org.asynchttpclient.netty.EagerNettyResponseBodyPart;
import org.asynchttpclient.netty.LazyNettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.handler.DefaultConnectionStrategy;
import org.asynchttpclient.netty.ws.NettyWebSocket;

public class AdvancedConfig {
    private final Map<ChannelOption<Object>, Object> channelOptions = new HashMap<ChannelOption<Object>, Object>();
    private EventLoopGroup eventLoopGroup;
    private Class<? extends Channel> socketChannelClass;
    private AdditionalPipelineInitializer httpAdditionalPipelineInitializer;
    private AdditionalPipelineInitializer wsAdditionalPipelineInitializer;
    private ResponseBodyPartFactory bodyPartFactory = new EagerResponseBodyPartFactory();
    private ChannelPool channelPool;
    private Timer nettyTimer;
    private NettyWebSocketFactory nettyWebSocketFactory = new DefaultNettyWebSocketFactory();
    private ConnectionStrategy connectionStrategy = new DefaultConnectionStrategy();

    public <T> AdvancedConfig addChannelOption(ChannelOption<T> name, T value) {
        this.channelOptions.put(name, value);
        return this;
    }

    public Map<ChannelOption<Object>, Object> getChannelOptions() {
        return this.channelOptions;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public Class<? extends Channel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public void setSocketChannelClass(Class<? extends Channel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
    }

    public AdditionalPipelineInitializer getHttpAdditionalPipelineInitializer() {
        return this.httpAdditionalPipelineInitializer;
    }

    public void setHttpAdditionalPipelineInitializer(AdditionalPipelineInitializer httpAdditionalPipelineInitializer) {
        this.httpAdditionalPipelineInitializer = httpAdditionalPipelineInitializer;
    }

    public AdditionalPipelineInitializer getWsAdditionalPipelineInitializer() {
        return this.wsAdditionalPipelineInitializer;
    }

    public void setWsAdditionalPipelineInitializer(AdditionalPipelineInitializer wsAdditionalPipelineInitializer) {
        this.wsAdditionalPipelineInitializer = wsAdditionalPipelineInitializer;
    }

    public ResponseBodyPartFactory getBodyPartFactory() {
        return this.bodyPartFactory;
    }

    public void setBodyPartFactory(ResponseBodyPartFactory bodyPartFactory) {
        this.bodyPartFactory = bodyPartFactory;
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public void setChannelPool(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    public Timer getNettyTimer() {
        return this.nettyTimer;
    }

    public void setNettyTimer(Timer nettyTimer) {
        this.nettyTimer = nettyTimer;
    }

    public NettyWebSocketFactory getNettyWebSocketFactory() {
        return this.nettyWebSocketFactory;
    }

    public void setNettyWebSocketFactory(NettyWebSocketFactory nettyWebSocketFactory) {
        this.nettyWebSocketFactory = nettyWebSocketFactory;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public class DefaultNettyWebSocketFactory
    implements NettyWebSocketFactory {
        @Override
        public NettyWebSocket newNettyWebSocket(Channel channel, AsyncHttpClientConfig config) {
            return new NettyWebSocket(channel, config);
        }
    }

    public static interface NettyWebSocketFactory {
        public NettyWebSocket newNettyWebSocket(Channel var1, AsyncHttpClientConfig var2);
    }

    public static class LazyResponseBodyPartFactory
    implements ResponseBodyPartFactory {
        @Override
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
            return new LazyNettyResponseBodyPart(buf, last);
        }
    }

    public static class EagerResponseBodyPartFactory
    implements ResponseBodyPartFactory {
        @Override
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
            return new EagerNettyResponseBodyPart(buf, last);
        }
    }

    public static interface ResponseBodyPartFactory {
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }

    public static interface AdditionalPipelineInitializer {
        public void initPipeline(ChannelPipeline var1) throws Exception;
    }
}

