/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.NameResolution;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.ProxyUtils;

public abstract class ChannelConnector {
    protected final AsyncHandlerExtensions asyncHandlerExtensions;
    protected final InetSocketAddress localAddress;
    protected final InetSocketAddress[] remoteAddresses;
    protected volatile int i = 0;

    public ChannelConnector(Request request, ProxyServer proxy, boolean useProxy, AsyncHandler<?> asyncHandler) throws UnknownHostException {
        NameResolution[] resolutions;
        this.asyncHandlerExtensions = asyncHandler instanceof AsyncHandlerExtensions ? (AsyncHandlerExtensions)((Object)asyncHandler) : null;
        Uri uri = request.getUri();
        int port = uri.getExplicitPort();
        if (request.getInetAddress() != null) {
            resolutions = new NameResolution[]{new NameResolution(request.getInetAddress())};
        } else if (!useProxy || ProxyUtils.ignoreProxy(proxy, uri.getHost())) {
            resolutions = request.getNameResolver().resolve(uri.getHost());
        } else {
            resolutions = request.getNameResolver().resolve(proxy.getHost());
            int n = port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
        }
        if (this.asyncHandlerExtensions != null) {
            this.asyncHandlerExtensions.onDnsResolved(resolutions);
        }
        this.remoteAddresses = new InetSocketAddress[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            this.remoteAddresses[i] = new InetSocketAddress(resolutions[i].address, port);
        }
        this.localAddress = request.getLocalAddress() != null ? new InetSocketAddress(request.getLocalAddress(), 0) : null;
    }

    protected boolean pickNextRemoteAddress() {
        ++this.i;
        return this.i < this.remoteAddresses.length;
    }
}

