/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.channel.pool.ConnectionStrategy;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseHeaders;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.Protocol;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.ntlm.NtlmUtils;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.uri.Uri;
import org.reactivestreams.Publisher;

public final class HttpProtocol
extends Protocol {
    private final ConnectionStrategy connectionStrategy;

    public HttpProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, AdvancedConfig advancedConfig, NettyRequestSender requestSender) {
        super(channelManager, config, advancedConfig, requestSender);
        this.connectionStrategy = advancedConfig.getConnectionStrategy();
    }

    private Realm kerberosChallenge(Channel channel, List<String> authHeaders, Request request, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) {
        Uri uri = request.getUri();
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        try {
            String challengeHeader = SpnegoEngine.instance().generateToken(host);
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            return new Realm.RealmBuilder().clone(realm).setUri(uri).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (SpnegoEngineException throwable) {
            String ntlmAuthenticate = NtlmUtils.getNTLM(authHeaders);
            if (ntlmAuthenticate != null) {
                return this.ntlmChallenge(ntlmAuthenticate, request, headers, realm, future);
            }
            this.requestSender.abort(channel, future, throwable);
            return null;
        }
    }

    private Realm kerberosProxyChallenge(Channel channel, List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, NettyResponseFuture<?> future) {
        try {
            String challengeHeader = SpnegoEngine.instance().generateToken(proxyServer.getHost());
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            return proxyServer.realmBuilder().setUri(request.getUri()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (SpnegoEngineException throwable) {
            String ntlmAuthenticate = NtlmUtils.getNTLM(proxyAuth);
            if (ntlmAuthenticate != null) {
                return this.ntlmProxyChallenge(ntlmAuthenticate, request, proxyServer, headers, future);
            }
            this.requestSender.abort(channel, future, throwable);
            return null;
        }
    }

    private String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? "Proxy-Authorization" : "Authorization";
    }

    private void addNTLMAuthorizationHeader(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
        headers.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private Realm ntlmChallenge(String authenticateHeader, Request request, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            this.addNTLMAuthorizationHeader(headers, challengeHeader, false);
            future.getAndSetAuth(false);
        } else {
            this.addType3NTLMAuthorizationHeader(authenticateHeader, headers, realm, false);
        }
        return new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
    }

    private Realm ntlmProxyChallenge(String authenticateHeader, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, NettyResponseFuture<?> future) {
        future.getAndSetAuth(false);
        headers.remove("Proxy-Authorization");
        Realm realm = proxyServer.realmBuilder().setScheme(Realm.AuthScheme.NTLM).setUri(request.getUri()).setMethodName(request.getMethod()).build();
        this.addType3NTLMAuthorizationHeader(authenticateHeader, headers, realm, true);
        return realm;
    }

    private void addType3NTLMAuthorizationHeader(String authenticateHeader, FluentCaseInsensitiveStringsMap headers, Realm realm, boolean proxyInd) {
        headers.remove(this.authorizationHeaderName(proxyInd));
        if (authenticateHeader.startsWith("NTLM ")) {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            this.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) throws IOException {
        future.cancelTimeouts();
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.channelManager.drainChannelAndOffer(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future.getAsyncHandler(), keepAlive, future.getPartitionKey());
        }
        try {
            future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), (Throwable)t);
        }
    }

    private boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, NettyResponseBodyPart bodyPart) throws Exception {
        boolean interrupt;
        boolean bl = interrupt = handler.onBodyPartReceived(bodyPart) != AsyncHandler.State.CONTINUE;
        if (bodyPart.isUnderlyingConnectionToBeClosed()) {
            future.setKeepAlive(false);
        }
        return interrupt;
    }

    private boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) throws Exception {
        List wwwAuthHeaders;
        if (statusCode == HttpResponseStatus.UNAUTHORIZED.code() && realm != null && !future.getAndSetAuth(true) && !(wwwAuthHeaders = response.headers().getAll("WWW-Authenticate")).isEmpty()) {
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            boolean negociate = wwwAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = NtlmUtils.getNTLM(wwwAuthHeaders);
            if (!wwwAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmChallenge(ntlmAuthenticate, request, request.getHeaders(), realm, future);
            } else if (negociate) {
                newRealm = this.kerberosChallenge(channel, wwwAuthHeaders, request, request.getHeaders(), realm, future);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader((String)wwwAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders())).setRealm(newRealm)).build();
            this.logger.debug("Sending authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                future.setReuseChannel(true);
                this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future);
            }
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling100(final Channel channel, NettyResponseFuture<?> future, int statusCode) {
        if (statusCode == HttpResponseStatus.CONTINUE.code()) {
            future.setHeadersAlreadyWrittenOnContinue(true);
            future.setDontWriteBodyBecauseExpectContinue(false);
            Channels.setAttribute(channel, new Callback(future){

                @Override
                public void call() throws IOException {
                    Channels.setAttribute(channel, this.future);
                    HttpProtocol.this.requestSender.writeRequest(this.future, channel);
                }
            });
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling407(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) throws Exception {
        List proxyAuthHeaders;
        if (statusCode == HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code() && realm != null && !future.getAndSetAuth(true) && !(proxyAuthHeaders = response.headers().getAll("Proxy-Authenticate")).isEmpty()) {
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            FluentCaseInsensitiveStringsMap requestHeaders = request.getHeaders();
            boolean negociate = proxyAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = NtlmUtils.getNTLM(proxyAuthHeaders);
            if (!proxyAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmProxyChallenge(ntlmAuthenticate, request, proxyServer, requestHeaders, future);
            } else if (negociate) {
                newRealm = this.kerberosProxyChallenge(channel, proxyAuthHeaders, request, proxyServer, requestHeaders, future);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setOmitQuery(true).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader((String)proxyAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders())).setRealm(newRealm)).build();
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                future.setConnectAllowed(true);
                future.setReuseChannel(true);
                this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future);
            }
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, int statusCode, HttpRequest httpRequest) throws IOException {
        if (statusCode == HttpResponseStatus.OK.code() && httpRequest.getMethod() == HttpMethod.CONNECT) {
            if (future.isKeepAlive()) {
                future.attachChannel(channel, true);
            }
            Uri requestUri = request.getUri();
            this.logger.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)requestUri.getScheme());
            try {
                this.channelManager.upgradeProtocol(channel.pipeline(), requestUri);
                future.setReuseChannel(true);
                future.setConnectAllowed(false);
                this.requestSender.drainChannelAndExecuteNextRequest(channel, future, new RequestBuilder(future.getRequest()).build());
            }
            catch (GeneralSecurityException ex) {
                this.requestSender.abort(channel, future, ex);
            }
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status) throws IOException, Exception {
        if (!future.getAndSetStatusReceived(true) && handler.onStatusReceived(status) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseHeaders responseHeaders) throws IOException, Exception {
        if (!response.headers().isEmpty() && handler.onHeadersReceived(responseHeaders) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler) throws IOException {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher((EventExecutor)channel.eventLoop(), this.channelManager, future, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, (Object)publisher);
            if (streamedAsyncHandler.onStream((Publisher<HttpResponseBodyPart>)publisher) != AsyncHandler.State.CONTINUE) {
                this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
                return true;
            }
        }
        return false;
    }

    private boolean handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setHttpHeaders(response.headers());
        future.setKeepAlive(this.connectionStrategy.keepAlive(httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), this.config, response, channel);
        int statusCode = response.getStatus().code();
        Request request = future.getRequest();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        NettyResponseHeaders responseHeaders = new NettyResponseHeaders(response.headers());
        return this.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders) || this.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling407(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling100(channel, future, statusCode) || this.exitAfterHandlingRedirect(channel, future, response, request, statusCode, realm) || this.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, httpRequest) || this.exitAfterHandlingStatus(channel, future, response, handler, status) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders) || this.exitAfterHandlingReactiveStreams(channel, future, response, handler);
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean interrupt = false;
        boolean last = chunk instanceof LastHttpContent;
        if (last && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            NettyResponseHeaders responseHeaders = new NettyResponseHeaders(future.getHttpHeaders(), trailingHeaders);
            interrupt = handler.onHeadersReceived(responseHeaders) != AsyncHandler.State.CONTINUE;
        }
        ByteBuf buf = chunk.content();
        if (!(interrupt || handler instanceof StreamedAsyncHandler || buf.readableBytes() <= 0 && !last)) {
            NettyResponseBodyPart part = this.advancedConfig.getBodyPartFactory().newResponseBodyPart(buf, last);
            interrupt = this.updateBodyAndInterrupt(future, handler, part);
        }
        if (interrupt || last) {
            this.finishUpdate(future, channel, !last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        future.touch();
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            if (e instanceof HttpResponse) {
                if (this.handleHttpResponse((HttpResponse)e, channel, future, handler)) {
                    return;
                }
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            try {
                this.requestSender.abort(channel, future, t);
            }
            catch (Exception abortException) {
                this.logger.debug("Abort failed", (Throwable)abortException);
            }
            finally {
                this.finishUpdate(future, channel, false);
            }
            throw t;
        }
    }

    @Override
    public void onError(NettyResponseFuture<?> future, Throwable error) {
    }

    @Override
    public void onClose(NettyResponseFuture<?> future) {
    }
}

