/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.Realm;

public class ProxyServer {
    private final List<String> nonProxyHosts = new ArrayList<String>();
    private final Protocol protocol;
    private final String host;
    private final String principal;
    private final String password;
    private final int port;
    private final int securedPort;
    private Charset charset = StandardCharsets.UTF_8;
    private String ntlmDomain = System.getProperty("http.auth.ntlm.domain");
    private String ntlmHost;
    private Realm.AuthScheme scheme;
    private boolean forceHttp10 = false;

    public ProxyServer(Protocol protocol, String host, int port, int securedPort, String principal, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.securedPort = securedPort;
        this.principal = principal;
        this.password = password;
        this.scheme = principal == null ? Realm.AuthScheme.NONE : Realm.AuthScheme.BASIC;
    }

    public ProxyServer(Protocol protocol, String host, int port, String principal, String password) {
        this(protocol, host, port, port, principal, password);
    }

    public ProxyServer(String host, int port, String principal, String password) {
        this(Protocol.HTTP, host, port, principal, password);
    }

    public ProxyServer(Protocol protocol, String host, int port) {
        this(protocol, host, port, null, null);
    }

    public ProxyServer(String host, int port) {
        this(Protocol.HTTP, host, port, null, null);
    }

    public Realm.RealmBuilder realmBuilder() {
        return new Realm.RealmBuilder().setNtlmDomain(this.ntlmDomain).setNtlmHost(this.ntlmHost).setPrincipal(this.principal).setPassword(this.password).setScheme(this.scheme);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSecuredPort() {
        return this.securedPort;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyServer setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ProxyServer addNonProxyHost(String uri) {
        this.nonProxyHosts.add(uri);
        return this;
    }

    public ProxyServer removeNonProxyHost(String uri) {
        this.nonProxyHosts.remove(uri);
        return this;
    }

    public List<String> getNonProxyHosts() {
        return Collections.unmodifiableList(this.nonProxyHosts);
    }

    public ProxyServer setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
        return this;
    }

    public Realm.AuthScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(Realm.AuthScheme scheme) {
        if (this.principal == null) {
            throw new NullPointerException("principal");
        }
        if (this.password == null) {
            throw new NullPointerException("password");
        }
        this.scheme = scheme;
    }

    public void setNtlmHost(String ntlmHost) {
        this.ntlmHost = ntlmHost;
    }

    public boolean isForceHttp10() {
        return this.forceHttp10;
    }

    public void setForceHttp10(boolean forceHttp10) {
        this.forceHttp10 = forceHttp10;
    }

    public static enum Protocol {
        HTTP("HTTP"),
        NTLM("NTLM"),
        KERBEROS("KERBEROS"),
        SPNEGO("SPNEGO");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.getProtocol();
        }
    }
}

