/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.NameResolver;
import org.asynchttpclient.channel.pool.ConnectionPoolPartitioning;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;

public class DefaultRequest
implements Request {
    private final String method;
    private final Uri uri;
    private final InetAddress address;
    private final InetAddress localAddress;
    private final HttpHeaders headers;
    private final List<Cookie> cookies;
    private final byte[] byteData;
    private final List<byte[]> compositeByteData;
    private final String stringData;
    private final ByteBuffer byteBufferData;
    private final InputStream streamData;
    private final BodyGenerator bodyGenerator;
    private final List<Param> formParams;
    private final List<Part> bodyParts;
    private final String virtualHost;
    private final long contentLength;
    public final ProxyServer proxyServer;
    private final Realm realm;
    private final File file;
    private final Boolean followRedirect;
    private final int requestTimeout;
    private final long rangeOffset;
    private final Charset charset;
    private final ConnectionPoolPartitioning connectionPoolPartitioning;
    private final NameResolver nameResolver;
    private List<Param> queryParams;

    public DefaultRequest(String method, Uri uri, InetAddress address, InetAddress localAddress, HttpHeaders headers, List<Cookie> cookies, byte[] byteData, List<byte[]> compositeByteData, String stringData, ByteBuffer byteBufferData, InputStream streamData, BodyGenerator bodyGenerator, List<Param> formParams, List<Part> bodyParts, String virtualHost, long contentLength, ProxyServer proxyServer, Realm realm, File file, Boolean followRedirect, int requestTimeout, long rangeOffset, Charset charset, ConnectionPoolPartitioning connectionPoolPartitioning, NameResolver nameResolver) {
        this.method = method;
        this.uri = uri;
        this.address = address;
        this.localAddress = localAddress;
        this.headers = headers;
        this.cookies = cookies;
        this.byteData = byteData;
        this.compositeByteData = compositeByteData;
        this.stringData = stringData;
        this.byteBufferData = byteBufferData;
        this.streamData = streamData;
        this.bodyGenerator = bodyGenerator;
        this.formParams = formParams;
        this.bodyParts = bodyParts;
        this.virtualHost = virtualHost;
        this.contentLength = contentLength;
        this.proxyServer = proxyServer;
        this.realm = realm;
        this.file = file;
        this.followRedirect = followRedirect;
        this.requestTimeout = requestTimeout;
        this.rangeOffset = rangeOffset;
        this.charset = charset;
        this.connectionPoolPartitioning = connectionPoolPartitioning;
        this.nameResolver = nameResolver;
    }

    @Override
    public String getUrl() {
        return this.uri.toUrl();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public byte[] getByteData() {
        return this.byteData;
    }

    @Override
    public List<byte[]> getCompositeByteData() {
        return this.compositeByteData;
    }

    @Override
    public String getStringData() {
        return this.stringData;
    }

    @Override
    public ByteBuffer getByteBufferData() {
        return this.byteBufferData;
    }

    @Override
    public InputStream getStreamData() {
        return this.streamData;
    }

    @Override
    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @Override
    public List<Param> getFormParams() {
        return this.formParams;
    }

    @Override
    public List<Part> getBodyParts() {
        return this.bodyParts;
    }

    @Override
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Boolean getFollowRedirect() {
        return this.followRedirect;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public long getRangeOffset() {
        return this.rangeOffset;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public ConnectionPoolPartitioning getConnectionPoolPartitioning() {
        return this.connectionPoolPartitioning;
    }

    @Override
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    public List<Param> getQueryParams() {
        if (this.queryParams == null) {
            if (MiscUtils.isNonEmpty(this.uri.getQuery())) {
                this.queryParams = new ArrayList<Param>(1);
                for (String queryStringParam : this.uri.getQuery().split("&")) {
                    int pos = queryStringParam.indexOf(61);
                    if (pos <= 0) {
                        this.queryParams.add(new Param(queryStringParam, null));
                        continue;
                    }
                    this.queryParams.add(new Param(queryStringParam.substring(0, pos), queryStringParam.substring(pos + 1)));
                }
            } else {
                this.queryParams = Collections.emptyList();
            }
        }
        return this.queryParams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUrl());
        sb.append("\t");
        sb.append(this.method);
        sb.append("\theaders:");
        if (!this.headers.isEmpty()) {
            for (Map.Entry header : this.headers) {
                sb.append("\t");
                sb.append((String)header.getKey());
                sb.append(":");
                sb.append((String)header.getValue());
            }
        }
        if (MiscUtils.isNonEmpty(this.formParams)) {
            sb.append("\tformParams:");
            for (Param param : this.formParams) {
                sb.append("\t");
                sb.append(param.getName());
                sb.append(":");
                sb.append(param.getValue());
            }
        }
        return sb.toString();
    }
}

