/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadLocalRandom;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;

public class Realm {
    private static final String DEFAULT_NC = "00000001";
    private static final String EMPTY_ENTITY_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    private final String principal;
    private final String password;
    private final AuthScheme scheme;
    private final String realmName;
    private final String nonce;
    private final String algorithm;
    private final String response;
    private final String opaque;
    private final String qop;
    private final String nc;
    private final String cnonce;
    private final Uri uri;
    private final String methodName;
    private final boolean usePreemptiveAuth;
    private final Charset charset;
    private final String ntlmHost;
    private final String ntlmDomain;
    private final boolean useAbsoluteURI;
    private final boolean omitQuery;

    private Realm(AuthScheme scheme, String principal, String password, String realmName, String nonce, String algorithm, String response, String qop, String nc, String cnonce, Uri uri, String method, boolean usePreemptiveAuth, String ntlmDomain, Charset charset, String host, String opaque, boolean useAbsoluteURI, boolean omitQuery) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (principal == null) {
            throw new NullPointerException("principal");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.principal = principal;
        this.password = password;
        this.scheme = scheme;
        this.realmName = realmName;
        this.nonce = nonce;
        this.algorithm = algorithm;
        this.response = response;
        this.opaque = opaque;
        this.qop = qop;
        this.nc = nc;
        this.cnonce = cnonce;
        this.uri = uri;
        this.methodName = method;
        this.usePreemptiveAuth = usePreemptiveAuth;
        this.ntlmDomain = ntlmDomain;
        this.ntlmHost = host;
        this.charset = charset;
        this.useAbsoluteURI = useAbsoluteURI;
        this.omitQuery = omitQuery;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isUsePreemptiveAuth() {
        return this.usePreemptiveAuth;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getNtlmHost() {
        return this.ntlmHost;
    }

    public boolean isUseAbsoluteURI() {
        return this.useAbsoluteURI;
    }

    public boolean isOmitQuery() {
        return this.omitQuery;
    }

    public String toString() {
        return "Realm{principal='" + this.principal + '\'' + ", scheme=" + (Object)((Object)this.scheme) + ", realmName='" + this.realmName + '\'' + ", nonce='" + this.nonce + '\'' + ", algorithm='" + this.algorithm + '\'' + ", response='" + this.response + '\'' + ", qop='" + this.qop + '\'' + ", nc='" + this.nc + '\'' + ", cnonce='" + this.cnonce + '\'' + ", uri='" + this.uri + '\'' + ", methodName='" + this.methodName + '\'' + ", useAbsoluteURI='" + this.useAbsoluteURI + '\'' + ", omitQuery='" + this.omitQuery + '\'' + '}';
    }

    public static class Builder {
        private static final ThreadLocal<MessageDigest> DIGEST_TL = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        private String principal;
        private String password;
        private AuthScheme scheme;
        private String realmName;
        private String nonce;
        private String algorithm;
        private String response;
        private String opaque;
        private String qop;
        private String nc = "00000001";
        private String cnonce;
        private Uri uri;
        private String methodName = "GET";
        private boolean usePreemptive;
        private String ntlmDomain = System.getProperty("http.auth.ntlm.domain");
        private Charset charset = StandardCharsets.UTF_8;
        private String ntlmHost = "localhost";
        private boolean useAbsoluteURI = false;
        private boolean omitQuery;

        public Builder setNtlmDomain(String ntlmDomain) {
            this.ntlmDomain = ntlmDomain;
            return this;
        }

        public Builder setNtlmHost(String host) {
            this.ntlmHost = host;
            return this;
        }

        public Builder setPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setScheme(AuthScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setResponse(String response) {
            this.response = response;
            return this;
        }

        public Builder setOpaque(String opaque) {
            this.opaque = opaque;
            return this;
        }

        public Builder setQop(String qop) {
            if (MiscUtils.isNonEmpty(qop)) {
                this.qop = qop;
            }
            return this;
        }

        public Builder setNc(String nc) {
            this.nc = nc;
            return this;
        }

        public Builder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder setUsePreemptiveAuth(boolean usePreemptiveAuth) {
            this.usePreemptive = usePreemptiveAuth;
            return this;
        }

        public Builder setUseAbsoluteURI(boolean useAbsoluteURI) {
            this.useAbsoluteURI = useAbsoluteURI;
            return this;
        }

        public Builder setOmitQuery(boolean omitQuery) {
            this.omitQuery = omitQuery;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        private String parseRawQop(String rawQop) {
            String[] rawServerSupportedQops = rawQop.split(",");
            String[] serverSupportedQops = new String[rawServerSupportedQops.length];
            for (int i = 0; i < rawServerSupportedQops.length; ++i) {
                serverSupportedQops[i] = rawServerSupportedQops[i].trim();
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!rawServerSupportedQop.equals("auth")) continue;
                return rawServerSupportedQop;
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!rawServerSupportedQop.equals("auth-int")) continue;
                return rawServerSupportedQop;
            }
            return null;
        }

        public Builder parseWWWAuthenticateHeader(String headerLine) {
            String rawQop;
            this.setRealmName(this.match(headerLine, "realm")).setNonce(this.match(headerLine, "nonce")).setOpaque(this.match(headerLine, "opaque")).setScheme(MiscUtils.isNonEmpty(this.nonce) ? AuthScheme.DIGEST : AuthScheme.BASIC);
            String algorithm = this.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            if ((rawQop = this.match(headerLine, "qop")) != null) {
                this.setQop(this.parseRawQop(rawQop));
            }
            return this;
        }

        public Builder parseProxyAuthenticateHeader(String headerLine) {
            this.setRealmName(this.match(headerLine, "realm")).setNonce(this.match(headerLine, "nonce")).setOpaque(this.match(headerLine, "opaque")).setScheme(MiscUtils.isNonEmpty(this.nonce) ? AuthScheme.DIGEST : AuthScheme.BASIC);
            String algorithm = this.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            this.setQop(this.match(headerLine, "qop"));
            return this;
        }

        private void newCnonce(MessageDigest md) {
            byte[] b = new byte[8];
            ThreadLocalRandom.current().nextBytes(b);
            b = md.digest(b);
            this.cnonce = Builder.toHexString(b);
        }

        private String match(String headerLine, String token) {
            if (headerLine == null) {
                return null;
            }
            int match = headerLine.indexOf(token);
            if (match <= 0) {
                return null;
            }
            int trailingComa = headerLine.indexOf(",", match += token.length() + 1);
            String value = headerLine.substring(match, trailingComa > 0 ? trailingComa : headerLine.length());
            value = value.length() > 0 && value.charAt(value.length() - 1) == '\"' ? value.substring(0, value.length() - 1) : value;
            return value.charAt(0) == '\"' ? value.substring(1) : value;
        }

        private byte[] md5FromRecycledStringBuilder(StringBuilder sb, MessageDigest md) {
            md.update(StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.ISO_8859_1));
            sb.setLength(0);
            return md.digest();
        }

        private byte[] secretDigest(StringBuilder sb, MessageDigest md) {
            sb.append(this.principal).append(':').append(this.realmName).append(':').append(this.password);
            byte[] ha1 = this.md5FromRecycledStringBuilder(sb, md);
            if (this.algorithm == null || this.algorithm.equals("MD5")) {
                return ha1;
            }
            if ("MD5-sess".equals(this.algorithm)) {
                Builder.appendBase16(sb, ha1);
                sb.append(':').append(this.nonce).append(':').append(this.cnonce);
                return this.md5FromRecycledStringBuilder(sb, md);
            }
            throw new UnsupportedOperationException("Digest algorithm not supported: " + this.algorithm);
        }

        private byte[] dataDigest(StringBuilder sb, String digestUri, MessageDigest md) {
            sb.append(this.methodName).append(':').append(digestUri);
            if ("auth-int".equals(this.qop)) {
                sb.append(':').append(Realm.EMPTY_ENTITY_MD5);
            } else if (this.qop != null && !this.qop.equals("auth")) {
                throw new UnsupportedOperationException("Digest qop not supported: " + this.qop);
            }
            return this.md5FromRecycledStringBuilder(sb, md);
        }

        private void appendDataBase(StringBuilder sb) {
            sb.append(':').append(this.nonce).append(':');
            if ("auth".equals(this.qop) || "auth-int".equals(this.qop)) {
                sb.append(this.nc).append(':').append(this.cnonce).append(':').append(this.qop).append(':');
            }
        }

        private void newResponse(MessageDigest md) {
            String digestUri = AuthenticatorUtils.computeRealmURI(this.uri, this.useAbsoluteURI, this.omitQuery);
            StringBuilder sb = StringUtils.stringBuilder();
            byte[] secretDigest = this.secretDigest(sb, md);
            byte[] dataDigest = this.dataDigest(sb, digestUri, md);
            Builder.appendBase16(sb, secretDigest);
            this.appendDataBase(sb);
            Builder.appendBase16(sb, dataDigest);
            byte[] responseDigest = this.md5FromRecycledStringBuilder(sb, md);
            this.response = Builder.toHexString(responseDigest);
        }

        private static String toHexString(byte[] data) {
            StringBuilder buffer = StringUtils.stringBuilder();
            for (int i = 0; i < data.length; ++i) {
                buffer.append(Integer.toHexString((data[i] & 0xF0) >>> 4));
                buffer.append(Integer.toHexString(data[i] & 0xF));
            }
            return buffer.toString();
        }

        private static void appendBase16(StringBuilder buf, byte[] bytes) {
            int base = 16;
            for (byte b : bytes) {
                int bi = 0xFF & b;
                int c = 48 + bi / base % base;
                if (c > 57) {
                    c = 97 + (c - 48 - 10);
                }
                buf.append((char)c);
                c = 48 + bi % base;
                if (c > 57) {
                    c = 97 + (c - 48 - 10);
                }
                buf.append((char)c);
            }
        }

        public Realm build() {
            if (MiscUtils.isNonEmpty(this.nonce)) {
                MessageDigest md = DIGEST_TL.get();
                this.newCnonce(md);
                this.newResponse(md);
            }
            return new Realm(this.scheme, this.principal, this.password, this.realmName, this.nonce, this.algorithm, this.response, this.qop, this.nc, this.cnonce, this.uri, this.methodName, this.usePreemptive, this.ntlmDomain, this.charset, this.ntlmHost, this.opaque, this.useAbsoluteURI, this.omitQuery);
        }
    }

    public static enum AuthScheme {
        BASIC,
        DIGEST,
        NTLM,
        SPNEGO,
        KERBEROS;

    }
}

