/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.channel.pool.ConnectionStrategy;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseHeaders;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.Protocol;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.reactivestreams.Publisher;

public final class HttpProtocol
extends Protocol {
    private final ConnectionStrategy connectionStrategy;

    public HttpProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, AdvancedConfig advancedConfig, NettyRequestSender requestSender) {
        super(channelManager, config, advancedConfig, requestSender);
        this.connectionStrategy = advancedConfig.getConnectionStrategy();
    }

    private void kerberosChallenge(Channel channel, List<String> authHeaders, Request request, HttpHeaders headers, Realm realm, NettyResponseFuture<?> future) throws SpnegoEngineException {
        Uri uri = request.getUri();
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        String challengeHeader = SpnegoEngine.instance().generateToken(host);
        headers.set("Authorization", (Object)("Negotiate " + challengeHeader));
    }

    private void kerberosProxyChallenge(Channel channel, List<String> proxyAuth, Request request, ProxyServer proxyServer, Realm proxyRealm, HttpHeaders headers, NettyResponseFuture<?> future) throws SpnegoEngineException {
        String challengeHeader = SpnegoEngine.instance().generateToken(proxyServer.getHost());
        headers.set("Proxy-Authorization", (Object)("Negotiate " + challengeHeader));
    }

    private void ntlmChallenge(String authenticateHeader, Request request, HttpHeaders headers, Realm realm, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            headers.set("Authorization", (Object)("NTLM " + challengeHeader));
            future.getInAuth().set(false);
        } else {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            headers.set("Authorization", (Object)("NTLM " + challengeHeader));
        }
    }

    private void ntlmProxyChallenge(String authenticateHeader, Request request, Realm proxyRealm, HttpHeaders headers, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            headers.set("Proxy-Authorization", (Object)("NTLM " + challengeHeader));
            future.getInProxyAuth().set(false);
        } else {
            String serverChallenge = authenticateHeader.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(proxyRealm.getPrincipal(), proxyRealm.getPassword(), proxyRealm.getNtlmDomain(), proxyRealm.getNtlmHost(), serverChallenge);
            headers.set("Proxy-Authorization", (Object)("NTLM " + challengeHeader));
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) throws IOException {
        future.cancelTimeouts();
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.channelManager.drainChannelAndOffer(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future.getAsyncHandler(), keepAlive, future.getPartitionKey());
        }
        try {
            future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), (Throwable)t);
        }
    }

    private boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, NettyResponseBodyPart bodyPart) throws Exception {
        boolean interrupt;
        boolean bl = interrupt = handler.onBodyPartReceived(bodyPart) != AsyncHandler.State.CONTINUE;
        if (bodyPart.isUnderlyingConnectionToBeClosed()) {
            future.setKeepAlive(false);
        }
        return interrupt;
    }

    private boolean exitAfterHandling100(final Channel channel, NettyResponseFuture<?> future, int statusCode) {
        if (statusCode == HttpResponseStatus.CONTINUE.code()) {
            future.setHeadersAlreadyWrittenOnContinue(true);
            future.setDontWriteBodyBecauseExpectContinue(false);
            Channels.setAttribute(channel, new Callback(future){

                @Override
                public void call() throws IOException {
                    Channels.setAttribute(channel, this.future);
                    HttpProtocol.this.requestSender.writeRequest(this.future, channel);
                }
            });
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) {
        if (statusCode != HttpResponseStatus.UNAUTHORIZED.code()) {
            return false;
        }
        if (realm == null) {
            this.logger.info("Can't handle 401 as there's no realm");
            return false;
        }
        if (future.getInAuth().getAndSet(true)) {
            this.logger.info("Can't handle 401 as auth was already performed");
            return false;
        }
        List wwwAuthHeaders = response.headers().getAll("WWW-Authenticate");
        if (wwwAuthHeaders.isEmpty()) {
            this.logger.info("Can't handle 401 as response doesn't contain WWW-Authenticate headers");
            return false;
        }
        future.setState(NettyResponseFuture.STATE.NEW);
        HttpHeaders requestHeaders = new DefaultHttpHeaders().add(request.getHeaders());
        switch (realm.getScheme()) {
            case BASIC: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Basic") == null) {
                    this.logger.info("Can't handle 401 with Basic realm as WWW-Authenticate headers don't match");
                    return false;
                }
                if (realm.isUsePreemptiveAuth()) {
                    this.logger.info("Can't handle 401 with Basic realm as auth was preemptive and already performed");
                    return false;
                }
                Realm newBasicRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future.setRealm(newBasicRealm);
                break;
            }
            case DIGEST: {
                String digestHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Digest");
                if (digestHeader == null) {
                    this.logger.info("Can't handle 401 with Digest realm as WWW-Authenticate headers don't match");
                    return false;
                }
                Realm newDigestRealm = Dsl.realm(realm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(digestHeader).build();
                future.setRealm(newDigestRealm);
                break;
            }
            case NTLM: {
                String ntlmHeader = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                if (ntlmHeader == null) {
                    this.logger.info("Can't handle 401 with NTLM realm as WWW-Authenticate headers don't match");
                    return false;
                }
                this.ntlmChallenge(ntlmHeader, request, requestHeaders, realm, future);
                Realm newNtlmRealm = Dsl.realm(realm).setUsePreemptiveAuth(true).build();
                future.setRealm(newNtlmRealm);
                break;
            }
            case KERBEROS: 
            case SPNEGO: {
                if (AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "Negociate") == null) {
                    this.logger.info("Can't handle 401 with Kerberos or Spnego realm as WWW-Authenticate headers don't match");
                    return false;
                }
                try {
                    this.kerberosChallenge(channel, wwwAuthHeaders, request, requestHeaders, realm, future);
                    break;
                }
                catch (SpnegoEngineException e) {
                    String ntlmHeader2 = AuthenticatorUtils.getHeaderWithPrefix(wwwAuthHeaders, "NTLM");
                    if (ntlmHeader2 != null) {
                        this.logger.warn("Kerberos/Spnego auth failed, proceeding with NTLM");
                        this.ntlmChallenge(ntlmHeader2, request, requestHeaders, realm, future);
                        Realm newNtlmRealm2 = Dsl.realm(realm).setScheme(Realm.AuthScheme.NTLM).setUsePreemptiveAuth(true).build();
                        future.setRealm(newNtlmRealm2);
                        break;
                    }
                    this.requestSender.abort(channel, future, e);
                    return false;
                }
            }
            default: {
                throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)realm.getScheme()));
            }
        }
        Request nextRequest = ((RequestBuilder)new RequestBuilder(future.getCurrentRequest()).setHeaders(requestHeaders)).build();
        this.logger.debug("Sending authentication to {}", (Object)request.getUri());
        if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
            future.setReuseChannel(true);
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
        } else {
            this.channelManager.closeChannel(channel);
            this.requestSender.sendNextRequest(nextRequest, future);
        }
        return true;
    }

    private boolean exitAfterHandling407(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, ProxyServer proxyServer) {
        if (statusCode != HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code()) {
            return false;
        }
        if (future.getInProxyAuth().getAndSet(true)) {
            this.logger.info("Can't handle 407 as auth was already performed");
            return false;
        }
        Realm proxyRealm = future.getProxyRealm();
        if (proxyRealm == null) {
            this.logger.info("Can't handle 407 as there's no proxyRealm");
            return false;
        }
        List proxyAuthHeaders = response.headers().getAll("Proxy-Authenticate");
        if (proxyAuthHeaders.isEmpty()) {
            this.logger.info("Can't handle 407 as response doesn't contain Proxy-Authenticate headers");
            return false;
        }
        future.setState(NettyResponseFuture.STATE.NEW);
        HttpHeaders requestHeaders = new DefaultHttpHeaders().add(request.getHeaders());
        switch (proxyRealm.getScheme()) {
            case BASIC: {
                if (AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Basic") == null) {
                    this.logger.info("Can't handle 407 with Basic realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                if (proxyRealm.isUsePreemptiveAuth()) {
                    this.logger.info("Can't handle 407 with Basic realm as auth was preemptive and already performed");
                    return false;
                }
                Realm newBasicRealm = Dsl.realm(proxyRealm).setUsePreemptiveAuth(true).build();
                future.setProxyRealm(newBasicRealm);
                break;
            }
            case DIGEST: {
                String digestHeader = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Digest");
                if (digestHeader == null) {
                    this.logger.info("Can't handle 407 with Digest realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                Realm newDigestRealm = Dsl.realm(proxyRealm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader(digestHeader).build();
                future.setProxyRealm(newDigestRealm);
                break;
            }
            case NTLM: {
                String ntlmHeader = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "NTLM");
                if (ntlmHeader == null) {
                    this.logger.info("Can't handle 407 with NTLM realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                this.ntlmProxyChallenge(ntlmHeader, request, proxyRealm, requestHeaders, future);
                Realm newNtlmRealm = Dsl.realm(proxyRealm).setUsePreemptiveAuth(true).build();
                future.setProxyRealm(newNtlmRealm);
                break;
            }
            case KERBEROS: 
            case SPNEGO: {
                if (AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "Negociate") == null) {
                    this.logger.info("Can't handle 407 with Kerberos or Spnego realm as Proxy-Authenticate headers don't match");
                    return false;
                }
                try {
                    this.kerberosProxyChallenge(channel, proxyAuthHeaders, request, proxyServer, proxyRealm, requestHeaders, future);
                    break;
                }
                catch (SpnegoEngineException e) {
                    String ntlmHeader2 = AuthenticatorUtils.getHeaderWithPrefix(proxyAuthHeaders, "NTLM");
                    if (ntlmHeader2 != null) {
                        this.logger.warn("Kerberos/Spnego proxy auth failed, proceeding with NTLM");
                        this.ntlmChallenge(ntlmHeader2, request, requestHeaders, proxyRealm, future);
                        Realm newNtlmRealm2 = Dsl.realm(proxyRealm).setScheme(Realm.AuthScheme.NTLM).setUsePreemptiveAuth(true).build();
                        future.setProxyRealm(newNtlmRealm2);
                        break;
                    }
                    this.requestSender.abort(channel, future, e);
                    return false;
                }
            }
            default: {
                throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
            }
        }
        RequestBuilder nextRequestBuilder = (RequestBuilder)new RequestBuilder(future.getCurrentRequest()).setHeaders(requestHeaders);
        if (future.getCurrentRequest().getUri().isSecured()) {
            nextRequestBuilder.setMethod(HttpMethod.CONNECT.name());
        }
        Request nextRequest = nextRequestBuilder.build();
        this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
        if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
            future.setConnectAllowed(true);
            future.setReuseChannel(true);
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
        } else {
            this.channelManager.closeChannel(channel);
            this.requestSender.sendNextRequest(nextRequest, future);
        }
        return true;
    }

    private boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, int statusCode, HttpRequest httpRequest) throws IOException {
        if (statusCode == HttpResponseStatus.OK.code() && httpRequest.getMethod() == HttpMethod.CONNECT) {
            if (future.isKeepAlive()) {
                future.attachChannel(channel, true);
            }
            Uri requestUri = request.getUri();
            this.logger.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)requestUri.getScheme());
            try {
                this.channelManager.upgradeProtocol(channel.pipeline(), requestUri);
                future.setReuseChannel(true);
                future.setConnectAllowed(false);
                this.requestSender.drainChannelAndExecuteNextRequest(channel, future, new RequestBuilder(future.getTargetRequest()).build());
            }
            catch (GeneralSecurityException ex) {
                this.requestSender.abort(channel, future, ex);
            }
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status) throws IOException, Exception {
        if (!future.getAndSetStatusReceived(true) && handler.onStatusReceived(status) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseHeaders responseHeaders) throws IOException, Exception {
        if (!response.headers().isEmpty() && handler.onHeadersReceived(responseHeaders) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingReactiveStreams(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler) throws IOException {
        if (handler instanceof StreamedAsyncHandler) {
            StreamedAsyncHandler streamedAsyncHandler = (StreamedAsyncHandler)handler;
            StreamedResponsePublisher publisher = new StreamedResponsePublisher((EventExecutor)channel.eventLoop(), this.channelManager, future, channel);
            channel.pipeline().addLast((EventExecutorGroup)channel.eventLoop(), "streamedAsyncHandler", (ChannelHandler)publisher);
            Channels.setAttribute(channel, (Object)publisher);
            if (streamedAsyncHandler.onStream((Publisher<HttpResponseBodyPart>)publisher) != AsyncHandler.State.CONTINUE) {
                this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
                return true;
            }
        }
        return false;
    }

    private boolean handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setHttpHeaders(response.headers());
        future.setKeepAlive(this.connectionStrategy.keepAlive(future.getTargetRequest(), httpRequest, response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), this.config, response, channel);
        int statusCode = response.getStatus().code();
        Request request = future.getCurrentRequest();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        NettyResponseHeaders responseHeaders = new NettyResponseHeaders(response.headers());
        return this.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders) || this.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling407(channel, future, response, request, statusCode, proxyServer) || this.exitAfterHandling100(channel, future, statusCode) || this.exitAfterHandlingRedirect(channel, future, response, request, statusCode, realm) || this.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, httpRequest) || this.exitAfterHandlingStatus(channel, future, response, handler, status) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders) || this.exitAfterHandlingReactiveStreams(channel, future, response, handler);
    }

    private void handleChunk(HttpContent chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws IOException, Exception {
        LastHttpContent lastChunk;
        HttpHeaders trailingHeaders;
        boolean interrupt = false;
        boolean last = chunk instanceof LastHttpContent;
        if (last && !(trailingHeaders = (lastChunk = (LastHttpContent)chunk).trailingHeaders()).isEmpty()) {
            NettyResponseHeaders responseHeaders = new NettyResponseHeaders(future.getHttpHeaders(), trailingHeaders);
            interrupt = handler.onHeadersReceived(responseHeaders) != AsyncHandler.State.CONTINUE;
        }
        ByteBuf buf = chunk.content();
        if (!(interrupt || handler instanceof StreamedAsyncHandler || buf.readableBytes() <= 0 && !last)) {
            NettyResponseBodyPart part = this.advancedConfig.getBodyPartFactory().newResponseBodyPart(buf, last);
            interrupt = this.updateBodyAndInterrupt(future, handler, part);
        }
        if (interrupt || last) {
            this.finishUpdate(future, channel, !last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        future.touch();
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            if (e instanceof HttpResponse) {
                if (this.handleHttpResponse((HttpResponse)e, channel, future, handler)) {
                    return;
                }
            } else if (e instanceof HttpContent) {
                this.handleChunk((HttpContent)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            try {
                this.requestSender.abort(channel, future, t);
            }
            catch (Exception abortException) {
                this.logger.debug("Abort failed", (Throwable)abortException);
            }
            finally {
                this.finishUpdate(future, channel, false);
            }
            throw t;
        }
    }

    @Override
    public void onError(NettyResponseFuture<?> future, Throwable error) {
    }

    @Override
    public void onClose(NettyResponseFuture<?> future) {
    }
}

