/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyServerSelector;
import org.asynchttpclient.util.ProxyUtils;

public class DefaultAsyncHttpClientConfig
implements AsyncHttpClientConfig {
    private static final String AHC_VERSION;
    private final int connectTimeout;
    private final int maxConnections;
    private final int maxConnectionsPerHost;
    private final int requestTimeout;
    private final int readTimeout;
    private final int webSocketTimeout;
    private final boolean allowPoolingConnections;
    private final int pooledConnectionIdleTimeout;
    private final int connectionTtl;
    private final SSLContext sslContext;
    private final boolean acceptAnyCertificate;
    private final boolean followRedirect;
    private final int maxRedirects;
    private final boolean strict302Handling;
    private final ProxyServerSelector proxyServerSelector;
    private final boolean compressionEnforced;
    private final String userAgent;
    private final String threadPoolName;
    private final ThreadFactory threadFactory;
    private final Realm realm;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private final List<IOExceptionFilter> ioExceptionFilters;
    private final int maxRequestRetry;
    private final boolean disableUrlEncodingForBoundRequests;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final Integer sslSessionCacheSize;
    private final Integer sslSessionTimeout;
    private final int httpClientCodecMaxInitialLineLength;
    private final int httpClientCodecMaxHeaderSize;
    private final int httpClientCodecMaxChunkSize;
    private final boolean disableZeroCopy;
    private final long handshakeTimeout;
    private final SSLEngineFactory sslEngineFactory;
    private final int chunkedFileChunkSize;
    private final int webSocketMaxBufferSize;
    private final int webSocketMaxFrameSize;
    private final boolean keepEncodingHeader;
    private final int shutdownQuietPeriod;
    private final int shutdownTimeout;
    private final AdvancedConfig advancedConfig;

    private DefaultAsyncHttpClientConfig(int connectTimeout, int maxConnections, int maxConnectionsPerHost, int requestTimeout, int readTimeout, int webSocketTimeout, boolean allowPoolingConnection, int idleConnectionInPoolTimeout, int connectionTtl, SSLContext sslContext, boolean acceptAnyCertificate, boolean followRedirect, int maxRedirects, boolean strict302Handling, String threadPoolName, ThreadFactory threadFactory, ProxyServerSelector proxyServerSelector, boolean compressionEnforced, String userAgent, Realm realm, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, int maxRequestRetry, boolean disableUrlEncodingForBoundRequests, String[] enabledProtocols, String[] enabledCipherSuites, Integer sslSessionCacheSize, Integer sslSessionTimeout, int httpClientCodecMaxInitialLineLength, int httpClientCodecMaxHeaderSize, int httpClientCodecMaxChunkSize, boolean disableZeroCopy, long handshakeTimeout, SSLEngineFactory sslEngineFactory, int chunkedFileChunkSize, int webSocketMaxBufferSize, int webSocketMaxFrameSize, boolean keepEncodingHeader, int shutdownQuietPeriod, int shutdownTimeout, AdvancedConfig advancedConfig) {
        this.connectTimeout = connectTimeout;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.webSocketTimeout = webSocketTimeout;
        this.allowPoolingConnections = allowPoolingConnection;
        this.pooledConnectionIdleTimeout = idleConnectionInPoolTimeout;
        this.connectionTtl = connectionTtl;
        this.sslContext = sslContext;
        this.acceptAnyCertificate = acceptAnyCertificate;
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.strict302Handling = strict302Handling;
        this.proxyServerSelector = proxyServerSelector;
        this.compressionEnforced = compressionEnforced;
        this.userAgent = userAgent;
        this.threadPoolName = threadPoolName;
        this.threadFactory = threadFactory;
        this.realm = realm;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.maxRequestRetry = maxRequestRetry;
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
        this.sslSessionCacheSize = sslSessionCacheSize;
        this.sslSessionTimeout = sslSessionTimeout;
        this.advancedConfig = advancedConfig;
        this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
        this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
        this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
        this.disableZeroCopy = disableZeroCopy;
        this.handshakeTimeout = handshakeTimeout;
        this.sslEngineFactory = sslEngineFactory;
        this.chunkedFileChunkSize = chunkedFileChunkSize;
        this.webSocketMaxBufferSize = webSocketMaxBufferSize;
        this.webSocketMaxFrameSize = webSocketMaxFrameSize;
        this.keepEncodingHeader = keepEncodingHeader;
        this.shutdownQuietPeriod = shutdownQuietPeriod;
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public String getAhcVersion() {
        return AHC_VERSION;
    }

    @Override
    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public String getThreadPoolNameOrDefault() {
        String r = this.threadPoolName;
        if (r == null || r.isEmpty()) {
            r = AsyncHttpClientConfigDefaults.defaultThreadPoolName();
        }
        if (r == null || r.isEmpty()) {
            r = "AsyncHttpClient";
        }
        return r;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public int getWebSocketTimeout() {
        return this.webSocketTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public int getPooledConnectionIdleTimeout() {
        return this.pooledConnectionIdleTimeout;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    @Override
    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public boolean isAllowPoolingConnections() {
        return this.allowPoolingConnections;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public boolean isCompressionEnforced() {
        return this.compressionEnforced;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public ProxyServerSelector getProxyServerSelector() {
        return this.proxyServerSelector;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public AdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    public List<ResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    @Override
    public List<IOExceptionFilter> getIOExceptionFilters() {
        return this.ioExceptionFilters;
    }

    @Override
    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    @Override
    public boolean isDisableUrlEncodingForBoundRequests() {
        return this.disableUrlEncodingForBoundRequests;
    }

    @Override
    public boolean isStrict302Handling() {
        return this.strict302Handling;
    }

    @Override
    public int getConnectionTtl() {
        return this.connectionTtl;
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public Integer getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    @Override
    public Integer getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    @Override
    public int getHttpClientCodecMaxInitialLineLength() {
        return this.httpClientCodecMaxInitialLineLength;
    }

    @Override
    public int getHttpClientCodecMaxHeaderSize() {
        return this.httpClientCodecMaxHeaderSize;
    }

    @Override
    public int getHttpClientCodecMaxChunkSize() {
        return this.httpClientCodecMaxChunkSize;
    }

    @Override
    public boolean isDisableZeroCopy() {
        return this.disableZeroCopy;
    }

    @Override
    public long getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @Override
    public SSLEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }

    @Override
    public int getChunkedFileChunkSize() {
        return this.chunkedFileChunkSize;
    }

    @Override
    public int getWebSocketMaxBufferSize() {
        return this.webSocketMaxBufferSize;
    }

    @Override
    public int getWebSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    @Override
    public boolean isKeepEncodingHeader() {
        return this.keepEncodingHeader;
    }

    @Override
    public int getShutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    @Override
    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    static {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = DefaultAsyncHttpClientConfig.class.getResourceAsStream("/ahc-version.properties");
            prop.load(is);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        AHC_VERSION = prop.getProperty("ahc.version", "UNKNOWN");
    }

    public static class Builder {
        private int connectTimeout = AsyncHttpClientConfigDefaults.defaultConnectTimeout();
        private int maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        private int maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        private int requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        private int readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        private int webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        private boolean allowPoolingConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnections();
        private int pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        private int connectionTtl = AsyncHttpClientConfigDefaults.defaultConnectionTtl();
        private SSLContext sslContext;
        private boolean acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        private boolean followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        private int maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        private boolean strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        private ProxyServerSelector proxyServerSelector;
        private boolean useProxySelector = AsyncHttpClientConfigDefaults.defaultUseProxySelector();
        private boolean useProxyProperties = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
        private boolean compressionEnforced = AsyncHttpClientConfigDefaults.defaultCompressionEnforced();
        private String userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        private String threadPoolName = AsyncHttpClientConfigDefaults.defaultThreadPoolName();
        private ThreadFactory threadFactory;
        private Realm realm;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private int maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        private boolean disableUrlEncodingForBoundRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        private String[] enabledProtocols = AsyncHttpClientConfigDefaults.defaultEnabledProtocols();
        private String[] enabledCipherSuites;
        private Integer sslSessionCacheSize = AsyncHttpClientConfigDefaults.defaultSslSessionCacheSize();
        private Integer sslSessionTimeout = AsyncHttpClientConfigDefaults.defaultSslSessionTimeout();
        private int httpClientCodecMaxInitialLineLength = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxInitialLineLength();
        private int httpClientCodecMaxHeaderSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxHeaderSize();
        private int httpClientCodecMaxChunkSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxChunkSize();
        private boolean disableZeroCopy = AsyncHttpClientConfigDefaults.defaultDisableZeroCopy();
        private long handshakeTimeout = AsyncHttpClientConfigDefaults.defaultHandshakeTimeout();
        private SSLEngineFactory sslEngineFactory;
        private int chunkedFileChunkSize = AsyncHttpClientConfigDefaults.defaultChunkedFileChunkSize();
        private int webSocketMaxBufferSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxBufferSize();
        private int webSocketMaxFrameSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxFrameSize();
        private boolean keepEncodingHeader = AsyncHttpClientConfigDefaults.defaultKeepEncodingHeader();
        private int shutdownQuietPeriod = AsyncHttpClientConfigDefaults.defaultShutdownQuietPeriod();
        private int shutdownTimeout = AsyncHttpClientConfigDefaults.defaultShutdownTimeout();
        private AdvancedConfig advancedConfig;

        public Builder() {
        }

        public Builder(AsyncHttpClientConfig config) {
            this.connectTimeout = config.getConnectTimeout();
            this.maxConnections = config.getMaxConnections();
            this.maxConnectionsPerHost = config.getMaxConnectionsPerHost();
            this.requestTimeout = config.getRequestTimeout();
            this.readTimeout = config.getReadTimeout();
            this.webSocketTimeout = config.getWebSocketTimeout();
            this.allowPoolingConnections = config.isAllowPoolingConnections();
            this.pooledConnectionIdleTimeout = config.getPooledConnectionIdleTimeout();
            this.connectionTtl = config.getConnectionTtl();
            this.sslContext = config.getSSLContext();
            this.acceptAnyCertificate = config.isAcceptAnyCertificate();
            this.followRedirect = config.isFollowRedirect();
            this.maxRedirects = config.getMaxRedirects();
            this.strict302Handling = config.isStrict302Handling();
            this.proxyServerSelector = config.getProxyServerSelector();
            this.compressionEnforced = config.isCompressionEnforced();
            this.userAgent = config.getUserAgent();
            this.threadPoolName = config.getThreadPoolName();
            this.threadFactory = config.getThreadFactory();
            this.realm = config.getRealm();
            this.requestFilters.addAll(config.getRequestFilters());
            this.responseFilters.addAll(config.getResponseFilters());
            this.ioExceptionFilters.addAll(config.getIOExceptionFilters());
            this.maxRequestRetry = config.getMaxRequestRetry();
            this.disableUrlEncodingForBoundRequests = config.isDisableUrlEncodingForBoundRequests();
            this.enabledProtocols = config.getEnabledProtocols();
            this.enabledCipherSuites = config.getEnabledCipherSuites();
            this.sslSessionCacheSize = config.getSslSessionCacheSize();
            this.sslSessionTimeout = config.getSslSessionTimeout();
            this.httpClientCodecMaxInitialLineLength = config.getHttpClientCodecMaxInitialLineLength();
            this.httpClientCodecMaxHeaderSize = config.getHttpClientCodecMaxHeaderSize();
            this.httpClientCodecMaxChunkSize = config.getHttpClientCodecMaxChunkSize();
            this.disableZeroCopy = config.isDisableZeroCopy();
            this.handshakeTimeout = config.getHandshakeTimeout();
            this.sslEngineFactory = config.getSslEngineFactory();
            this.chunkedFileChunkSize = config.getChunkedFileChunkSize();
            this.webSocketMaxBufferSize = config.getWebSocketMaxBufferSize();
            this.webSocketMaxFrameSize = config.getWebSocketMaxFrameSize();
            this.keepEncodingHeader = config.isKeepEncodingHeader();
            this.shutdownQuietPeriod = config.getShutdownQuietPeriod();
            this.shutdownTimeout = config.getShutdownTimeout();
            this.advancedConfig = config.getAdvancedConfig();
        }

        public Builder setThreadPoolName(String threadPoolName) {
            this.threadPoolName = threadPoolName;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setWebSocketTimeout(int webSocketTimeout) {
            this.webSocketTimeout = webSocketTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder setCompressionEnforced(boolean compressionEnforced) {
            this.compressionEnforced = compressionEnforced;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setAllowPoolingConnections(boolean allowPoolingConnections) {
            this.allowPoolingConnections = allowPoolingConnections;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
            this.proxyServerSelector = proxyServerSelector;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAdvancedConfig(AdvancedConfig advancedConfig) {
            this.advancedConfig = advancedConfig;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setDisableUrlEncodingForBoundRequests(boolean disableUrlEncodingForBoundRequests) {
            this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
            return this;
        }

        public Builder setUseProxySelector(boolean useProxySelector) {
            this.useProxySelector = useProxySelector;
            return this;
        }

        public Builder setUseProxyProperties(boolean useProxyProperties) {
            this.useProxyProperties = useProxyProperties;
            return this;
        }

        public Builder setStrict302Handling(boolean strict302Handling) {
            this.strict302Handling = strict302Handling;
            return this;
        }

        public Builder setConnectionTtl(int connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.acceptAnyCertificate = acceptAnyCertificate;
            return this;
        }

        public Builder setEnabledProtocols(String[] enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public Builder setEnabledCipherSuites(String[] enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public Builder setSslSessionCacheSize(Integer sslSessionCacheSize) {
            this.sslSessionCacheSize = sslSessionCacheSize;
            return this;
        }

        public Builder setSslSessionTimeout(Integer sslSessionTimeout) {
            this.sslSessionTimeout = sslSessionTimeout;
            return this;
        }

        public Builder setHttpClientCodecMaxInitialLineLength(int httpClientCodecMaxInitialLineLength) {
            this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
            return this;
        }

        public Builder setHttpClientCodecMaxHeaderSize(int httpClientCodecMaxHeaderSize) {
            this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
            return this;
        }

        public Builder setHttpClientCodecMaxChunkSize(int httpClientCodecMaxChunkSize) {
            this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
            return this;
        }

        public Builder setDisableZeroCopy(boolean disableZeroCopy) {
            this.disableZeroCopy = disableZeroCopy;
            return this;
        }

        public Builder setHandshakeTimeout(long handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        public Builder setSslEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
            return this;
        }

        public Builder setChunkedFileChunkSize(int chunkedFileChunkSize) {
            this.chunkedFileChunkSize = chunkedFileChunkSize;
            return this;
        }

        public Builder setWebSocketMaxBufferSize(int webSocketMaxBufferSize) {
            this.webSocketMaxBufferSize = webSocketMaxBufferSize;
            return this;
        }

        public Builder setWebSocketMaxFrameSize(int webSocketMaxFrameSize) {
            this.webSocketMaxFrameSize = webSocketMaxFrameSize;
            return this;
        }

        public Builder setKeepEncodingHeader(boolean keepEncodingHeader) {
            this.keepEncodingHeader = keepEncodingHeader;
            return this;
        }

        public Builder setShutdownQuietPeriod(int shutdownQuietPeriod) {
            this.shutdownQuietPeriod = shutdownQuietPeriod;
            return this;
        }

        public Builder setShutdownTimeout(int shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public DefaultAsyncHttpClientConfig build() {
            if (this.proxyServerSelector == null && this.useProxySelector) {
                this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
            }
            if (this.proxyServerSelector == null && this.useProxyProperties) {
                this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
            }
            if (this.proxyServerSelector == null) {
                this.proxyServerSelector = ProxyServerSelector.NO_PROXY_SELECTOR;
            }
            return new DefaultAsyncHttpClientConfig(this.connectTimeout, this.maxConnections, this.maxConnectionsPerHost, this.requestTimeout, this.readTimeout, this.webSocketTimeout, this.allowPoolingConnections, this.pooledConnectionIdleTimeout, this.connectionTtl, this.sslContext, this.acceptAnyCertificate, this.followRedirect, this.maxRedirects, this.strict302Handling, this.threadPoolName, this.threadFactory, this.proxyServerSelector, this.compressionEnforced, this.userAgent, this.realm, this.requestFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.requestFilters), this.responseFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.responseFilters), this.ioExceptionFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.ioExceptionFilters), this.maxRequestRetry, this.disableUrlEncodingForBoundRequests, this.enabledProtocols, this.enabledCipherSuites, this.sslSessionCacheSize, this.sslSessionTimeout, this.httpClientCodecMaxInitialLineLength, this.httpClientCodecMaxHeaderSize, this.httpClientCodecMaxChunkSize, this.disableZeroCopy, this.handshakeTimeout, this.sslEngineFactory, this.chunkedFileChunkSize, this.webSocketMaxBufferSize, this.webSocketMaxFrameSize, this.keepEncodingHeader, this.shutdownQuietPeriod, this.shutdownTimeout, this.advancedConfig);
        }
    }
}

