/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import java.util.HashSet;
import java.util.Set;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieDecoder;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.handler.MaxRedirectException;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Protocol {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelManager channelManager;
    protected final AsyncHttpClientConfig config;
    protected final AdvancedConfig advancedConfig;
    protected final NettyRequestSender requestSender;
    private final boolean hasResponseFilters;
    protected final boolean hasIOExceptionFilters;
    private final MaxRedirectException maxRedirectException;
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();

    public Protocol(ChannelManager channelManager, AsyncHttpClientConfig config, AdvancedConfig advancedConfig, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.requestSender = requestSender;
        this.advancedConfig = advancedConfig;
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
        this.hasIOExceptionFilters = !config.getIOExceptionFilters().isEmpty();
        this.maxRedirectException = new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects());
    }

    public abstract void handle(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void onError(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void onClose(NettyResponseFuture<?> var1);

    private HttpHeaders propagatedHeaders(Request request, Realm realm, boolean switchToGet) {
        HttpHeaders headers = request.getHeaders().remove("Host").remove("Content-Length").remove("Content-Type");
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.remove("Authorization").remove("Proxy-Authorization");
        }
        return headers;
    }

    protected boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm) throws Exception {
        if (HttpUtils.followRedirect(this.config, request) && REDIRECT_STATUSES.contains(statusCode)) {
            if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future.getInAuth().set(false);
            future.getInProxyAuth().set(false);
            String originalMethod = request.getMethod();
            boolean switchToGet = !originalMethod.equals(HttpMethod.GET.name()) && (statusCode == 301 || statusCode == 303 || statusCode == 302 && !this.config.isStrict302Handling());
            boolean keepBody = statusCode == 307 || statusCode == 302 && this.config.isStrict302Handling();
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? HttpMethod.GET.name() : originalMethod).setCookies(request.getCookies())).setConnectionPoolPartitioning(request.getConnectionPoolPartitioning())).setFollowRedirect(true)).setLocalAddress(request.getLocalAddress())).setNameResolver(request.getNameResolver())).setProxyServer(request.getProxyServer())).setRealm(request.getRealm())).setRequestTimeout(request.getRequestTimeout());
            if (keepBody) {
                requestBuilder.setCharset(request.getCharset());
                if (MiscUtils.isNonEmpty(request.getFormParams())) {
                    requestBuilder.setFormParams(request.getFormParams());
                } else if (request.getStringData() != null) {
                    requestBuilder.setBody(request.getStringData());
                } else if (request.getByteData() != null) {
                    requestBuilder.setBody(request.getByteData());
                } else if (request.getByteBufferData() != null) {
                    requestBuilder.setBody(request.getByteBufferData());
                } else if (request.getBodyGenerator() != null) {
                    requestBuilder.setBody(request.getBodyGenerator());
                }
            }
            requestBuilder.setHeaders(this.propagatedHeaders(request, realm, switchToGet));
            boolean initialConnectionKeepAlive = future.isKeepAlive();
            Object initialPartitionKey = future.getPartitionKey();
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get("Location");
            Uri newUri = Uri.create(future.getUri(), location);
            this.logger.debug("Redirecting to {}", (Object)newUri);
            for (String cookieStr : responseHeaders.getAll("Set-Cookie")) {
                Cookie c = CookieDecoder.decode(cookieStr);
                if (c == null) continue;
                requestBuilder.addOrReplaceCookie(c);
            }
            requestBuilder.setHeaders(this.propagatedHeaders(future.getCurrentRequest(), realm, switchToGet));
            boolean sameBase = HttpUtils.isSameBase(request.getUri(), newUri);
            if (sameBase) {
                requestBuilder.setVirtualHost(request.getVirtualHost());
            }
            Request nextRequest = ((RequestBuilder)requestBuilder.setUri(newUri)).build();
            future.setTargetRequest(nextRequest);
            this.logger.debug("Sending redirect to {}", (Object)newUri);
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                if (sameBase) {
                    future.setReuseChannel(true);
                    this.requestSender.drainChannelAndExecuteNextRequest(channel, future, nextRequest);
                } else {
                    this.channelManager.drainChannelAndOffer(channel, future, initialConnectionKeepAlive, initialPartitionKey);
                    this.requestSender.sendNextRequest(nextRequest, future);
                }
            } else {
                this.channelManager.closeChannel(channel);
                this.requestSender.sendNextRequest(nextRequest, future);
            }
            return true;
        }
        return false;
    }

    protected boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpResponseHeaders responseHeaders) {
        if (this.hasResponseFilters) {
            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
            for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                try {
                    if ((fc = asyncFilter.filter(fc)) != null) continue;
                    throw new NullPointerException("FilterContext is null");
                }
                catch (FilterException efe) {
                    this.requestSender.abort(channel, future, efe);
                }
            }
            future.setAsyncHandler(fc.getAsyncHandler());
            if (fc.replayRequest()) {
                this.requestSender.replayRequest(future, fc, channel);
                return true;
            }
        }
        return false;
    }

    static {
        REDIRECT_STATUSES.add(io.netty.handler.codec.http.HttpResponseStatus.MOVED_PERMANENTLY.code());
        REDIRECT_STATUSES.add(io.netty.handler.codec.http.HttpResponseStatus.FOUND.code());
        REDIRECT_STATUSES.add(io.netty.handler.codec.http.HttpResponseStatus.SEE_OTHER.code());
        REDIRECT_STATUSES.add(io.netty.handler.codec.http.HttpResponseStatus.TEMPORARY_REDIRECT.code());
    }
}

