/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ResponseBase;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieDecoder;
import org.asynchttpclient.util.MiscUtils;

public class NettyResponse
extends ResponseBase {
    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
    }

    @Override
    protected List<Cookie> buildCookies() {
        List setCookieHeaders = this.headers.getHeaders().getAll("Set-Cookie2");
        if (!MiscUtils.isNonEmpty(setCookieHeaders)) {
            setCookieHeaders = this.headers.getHeaders().getAll("Set-Cookie");
        }
        if (MiscUtils.isNonEmpty(setCookieHeaders)) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            for (String value : setCookieHeaders) {
                Cookie c = CookieDecoder.decode(value);
                if (c == null) continue;
                cookies.add(c);
            }
            return Collections.unmodifiableList(cookies);
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] getResponseBodyAsBytes() {
        return this.getResponseBodyAsByteBuffer().array();
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() {
        int length = 0;
        for (HttpResponseBodyPart part : this.bodyParts) {
            length += part.length();
        }
        ByteBuffer target = ByteBuffer.wrap(new byte[length]);
        for (HttpResponseBodyPart part : this.bodyParts) {
            target.put(part.getBodyPartBytes());
        }
        return target;
    }

    @Override
    public String getResponseBody() {
        return this.getResponseBody(null);
    }

    @Override
    public String getResponseBody(Charset charset) {
        return new String(this.getResponseBodyAsBytes(), this.calculateCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() {
        return new ByteArrayInputStream(this.getResponseBodyAsBytes());
    }
}

