/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.asynchttpclient.request.body.multipart.AbstractFilePart;
import org.asynchttpclient.request.body.multipart.FilePartStallHandler;
import org.asynchttpclient.request.body.multipart.FileUploadStalledException;
import org.asynchttpclient.request.body.multipart.MultipartUtils;
import org.asynchttpclient.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePart
extends AbstractFilePart {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePart.class);
    private final File file;

    public FilePart(String name, File file) {
        this(name, file, null);
    }

    public FilePart(String name, File file, String contentType) {
        this(name, file, contentType, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset) {
        this(name, file, contentType, charset, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName) {
        this(name, file, contentType, charset, fileName, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName, String contentId) {
        this(name, file, contentType, charset, fileName, contentId, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName, String contentId, String transferEncoding) {
        super(name, contentType, charset, contentId, transferEncoding);
        Assertions.assertNotNull(file, "file");
        if (!file.isFile()) {
            throw new IllegalArgumentException("File is not a normal file " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable " + file.getAbsolutePath());
        }
        this.file = file;
        this.setFileName(fileName != null ? fileName : file.getName());
    }

    @Override
    protected long getDataLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(WritableByteChannel target, byte[] boundary) throws IOException {
        FilePartStallHandler handler = new FilePartStallHandler(this.getStalledTime(), this);
        handler.start();
        int length = 0;
        length = (int)((long)length + MultipartUtils.writeBytesToChannel(target, this.generateFileStart(boundary)));
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        FileChannel fc = raf.getChannel();
        long fileLength = this.file.length();
        int position = 0;
        long nWrite = 0L;
        try {
            FileChannel fileChannel = fc;
            synchronized (fileChannel) {
                while ((long)position != fileLength) {
                    if (handler.isFailed()) {
                        LOGGER.debug("Stalled error");
                        throw new FileUploadStalledException();
                    }
                    nWrite = fc.transferTo(position, fileLength, target);
                    if (nWrite == 0L) {
                        LOGGER.info("Waiting for writing...");
                        try {
                            fc.wait(50L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.trace(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        handler.writeHappened();
                    }
                    position = (int)((long)position + nWrite);
                }
            }
        }
        finally {
            handler.completed();
            raf.close();
        }
        length = (int)((long)length + fileLength);
        length = (int)((long)length + MultipartUtils.writeBytesToChannel(target, this.generateFileEnd()));
        return length;
    }
}

