/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.channel.pool.KeepAliveStrategy;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyServerSelector;
import org.asynchttpclient.util.ProxyUtils;

public class DefaultAsyncHttpClientConfig
implements AsyncHttpClientConfig {
    private static final String AHC_VERSION;
    private final boolean followRedirect;
    private final int maxRedirects;
    private final boolean strict302Handling;
    private final boolean compressionEnforced;
    private final String userAgent;
    private final Realm realm;
    private final int maxRequestRetry;
    private final boolean disableUrlEncodingForBoundRequests;
    private final boolean disableZeroCopy;
    private final boolean keepEncodingHeader;
    private final ProxyServerSelector proxyServerSelector;
    private final int connectTimeout;
    private final int requestTimeout;
    private final int readTimeout;
    private final int webSocketTimeout;
    private final int shutdownQuietPeriod;
    private final int shutdownTimeout;
    private final boolean keepAlive;
    private final int pooledConnectionIdleTimeout;
    private final int connectionTtl;
    private final int maxConnections;
    private final int maxConnectionsPerHost;
    private final ChannelPool channelPool;
    private final KeepAliveStrategy keepAliveStrategy;
    private final boolean acceptAnyCertificate;
    private final int handshakeTimeout;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final Integer sslSessionCacheSize;
    private final Integer sslSessionTimeout;
    private final SSLContext sslContext;
    private final SSLEngineFactory sslEngineFactory;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private final List<IOExceptionFilter> ioExceptionFilters;
    private final String threadPoolName;
    private final int httpClientCodecMaxInitialLineLength;
    private final int httpClientCodecMaxHeaderSize;
    private final int httpClientCodecMaxChunkSize;
    private final int chunkedFileChunkSize;
    private final int webSocketMaxBufferSize;
    private final int webSocketMaxFrameSize;
    private final Map<ChannelOption<Object>, Object> channelOptions;
    private final EventLoopGroup eventLoopGroup;
    private final boolean preferNative;
    private final Timer nettyTimer;
    private final ThreadFactory threadFactory;
    private final AsyncHttpClientConfig.NettyWebSocketFactory nettyWebSocketFactory;
    private final AsyncHttpClientConfig.AdditionalPipelineInitializer httpAdditionalPipelineInitializer;
    private final AsyncHttpClientConfig.AdditionalPipelineInitializer wsAdditionalPipelineInitializer;
    private final AsyncHttpClientConfig.ResponseBodyPartFactory responseBodyPartFactory;

    private DefaultAsyncHttpClientConfig(boolean followRedirect, int maxRedirects, boolean strict302Handling, boolean compressionEnforced, String userAgent, Realm realm, int maxRequestRetry, boolean disableUrlEncodingForBoundRequests, boolean disableZeroCopy, boolean keepEncodingHeader, ProxyServerSelector proxyServerSelector, int connectTimeout, int requestTimeout, int readTimeout, int webSocketTimeout, int shutdownQuietPeriod, int shutdownTimeout, boolean keepAlive, int pooledConnectionIdleTimeout, int connectionTtl, int maxConnections, int maxConnectionsPerHost, ChannelPool channelPool, KeepAliveStrategy keepAliveStrategy, boolean acceptAnyCertificate, int handshakeTimeout, String[] enabledProtocols, String[] enabledCipherSuites, Integer sslSessionCacheSize, Integer sslSessionTimeout, SSLContext sslContext, SSLEngineFactory sslEngineFactory, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, List<IOExceptionFilter> ioExceptionFilters, String threadPoolName, int httpClientCodecMaxInitialLineLength, int httpClientCodecMaxHeaderSize, int httpClientCodecMaxChunkSize, int chunkedFileChunkSize, int webSocketMaxBufferSize, int webSocketMaxFrameSize, Map<ChannelOption<Object>, Object> channelOptions, EventLoopGroup eventLoopGroup, boolean preferNative, Timer nettyTimer, ThreadFactory threadFactory, AsyncHttpClientConfig.NettyWebSocketFactory nettyWebSocketFactory, AsyncHttpClientConfig.AdditionalPipelineInitializer httpAdditionalPipelineInitializer, AsyncHttpClientConfig.AdditionalPipelineInitializer wsAdditionalPipelineInitializer, AsyncHttpClientConfig.ResponseBodyPartFactory responseBodyPartFactory) {
        this.followRedirect = followRedirect;
        this.maxRedirects = maxRedirects;
        this.strict302Handling = strict302Handling;
        this.compressionEnforced = compressionEnforced;
        this.userAgent = userAgent;
        this.realm = realm;
        this.maxRequestRetry = maxRequestRetry;
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
        this.disableZeroCopy = disableZeroCopy;
        this.keepEncodingHeader = keepEncodingHeader;
        this.proxyServerSelector = proxyServerSelector;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.webSocketTimeout = webSocketTimeout;
        this.shutdownQuietPeriod = shutdownQuietPeriod;
        this.shutdownTimeout = shutdownTimeout;
        this.keepAlive = keepAlive;
        this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
        this.connectionTtl = connectionTtl;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.channelPool = channelPool;
        this.keepAliveStrategy = keepAliveStrategy;
        this.acceptAnyCertificate = acceptAnyCertificate;
        this.handshakeTimeout = handshakeTimeout;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
        this.sslSessionCacheSize = sslSessionCacheSize;
        this.sslSessionTimeout = sslSessionTimeout;
        this.sslContext = sslContext;
        this.sslEngineFactory = sslEngineFactory;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.ioExceptionFilters = ioExceptionFilters;
        this.threadPoolName = threadPoolName;
        this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
        this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
        this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
        this.chunkedFileChunkSize = chunkedFileChunkSize;
        this.webSocketMaxBufferSize = webSocketMaxBufferSize;
        this.webSocketMaxFrameSize = webSocketMaxFrameSize;
        this.channelOptions = channelOptions;
        this.eventLoopGroup = eventLoopGroup;
        this.preferNative = preferNative;
        this.nettyTimer = nettyTimer;
        this.threadFactory = threadFactory;
        this.nettyWebSocketFactory = nettyWebSocketFactory;
        this.httpAdditionalPipelineInitializer = httpAdditionalPipelineInitializer;
        this.wsAdditionalPipelineInitializer = wsAdditionalPipelineInitializer;
        this.responseBodyPartFactory = responseBodyPartFactory;
    }

    @Override
    public String getAhcVersion() {
        return AHC_VERSION;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    @Override
    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public boolean isStrict302Handling() {
        return this.strict302Handling;
    }

    @Override
    public boolean isCompressionEnforced() {
        return this.compressionEnforced;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public int getMaxRequestRetry() {
        return this.maxRequestRetry;
    }

    @Override
    public boolean isDisableUrlEncodingForBoundRequests() {
        return this.disableUrlEncodingForBoundRequests;
    }

    @Override
    public boolean isDisableZeroCopy() {
        return this.disableZeroCopy;
    }

    @Override
    public boolean isKeepEncodingHeader() {
        return this.keepEncodingHeader;
    }

    @Override
    public ProxyServerSelector getProxyServerSelector() {
        return this.proxyServerSelector;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public int getWebSocketTimeout() {
        return this.webSocketTimeout;
    }

    @Override
    public int getShutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    @Override
    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public int getPooledConnectionIdleTimeout() {
        return this.pooledConnectionIdleTimeout;
    }

    @Override
    public int getConnectionTtl() {
        return this.connectionTtl;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    @Override
    public KeepAliveStrategy getKeepAliveStrategy() {
        return this.keepAliveStrategy;
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    @Override
    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public Integer getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    @Override
    public Integer getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public SSLEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }

    @Override
    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    public List<ResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    @Override
    public List<IOExceptionFilter> getIoExceptionFilters() {
        return this.ioExceptionFilters;
    }

    @Override
    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public int getHttpClientCodecMaxInitialLineLength() {
        return this.httpClientCodecMaxInitialLineLength;
    }

    @Override
    public int getHttpClientCodecMaxHeaderSize() {
        return this.httpClientCodecMaxHeaderSize;
    }

    @Override
    public int getHttpClientCodecMaxChunkSize() {
        return this.httpClientCodecMaxChunkSize;
    }

    @Override
    public int getChunkedFileChunkSize() {
        return this.chunkedFileChunkSize;
    }

    @Override
    public int getWebSocketMaxBufferSize() {
        return this.webSocketMaxBufferSize;
    }

    @Override
    public int getWebSocketMaxFrameSize() {
        return this.webSocketMaxFrameSize;
    }

    @Override
    public Map<ChannelOption<Object>, Object> getChannelOptions() {
        return this.channelOptions;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public boolean isPreferNative() {
        return this.preferNative;
    }

    @Override
    public Timer getNettyTimer() {
        return this.nettyTimer;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public AsyncHttpClientConfig.NettyWebSocketFactory getNettyWebSocketFactory() {
        return this.nettyWebSocketFactory;
    }

    @Override
    public AsyncHttpClientConfig.AdditionalPipelineInitializer getHttpAdditionalPipelineInitializer() {
        return this.httpAdditionalPipelineInitializer;
    }

    @Override
    public AsyncHttpClientConfig.AdditionalPipelineInitializer getWsAdditionalPipelineInitializer() {
        return this.wsAdditionalPipelineInitializer;
    }

    @Override
    public AsyncHttpClientConfig.ResponseBodyPartFactory getResponseBodyPartFactory() {
        return this.responseBodyPartFactory;
    }

    static {
        try (InputStream is = DefaultAsyncHttpClientConfig.class.getResourceAsStream("/ahc-version.properties");){
            Properties prop = new Properties();
            prop.load(is);
            AHC_VERSION = prop.getProperty("ahc.version", "UNKNOWN");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class Builder {
        private boolean followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        private int maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        private boolean strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        private boolean compressionEnforced = AsyncHttpClientConfigDefaults.defaultCompressionEnforced();
        private String userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        private Realm realm;
        private int maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        private boolean disableUrlEncodingForBoundRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        private boolean disableZeroCopy = AsyncHttpClientConfigDefaults.defaultDisableZeroCopy();
        private boolean keepEncodingHeader = AsyncHttpClientConfigDefaults.defaultKeepEncodingHeader();
        private ProxyServerSelector proxyServerSelector;
        private boolean useProxySelector = AsyncHttpClientConfigDefaults.defaultUseProxySelector();
        private boolean useProxyProperties = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
        private int connectTimeout = AsyncHttpClientConfigDefaults.defaultConnectTimeout();
        private int requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        private int readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        private int webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        private int shutdownQuietPeriod = AsyncHttpClientConfigDefaults.defaultShutdownQuietPeriod();
        private int shutdownTimeout = AsyncHttpClientConfigDefaults.defaultShutdownTimeout();
        private boolean keepAlive = AsyncHttpClientConfigDefaults.defaultKeepAlive();
        private int pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        private int connectionTtl = AsyncHttpClientConfigDefaults.defaultConnectionTtl();
        private int maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        private int maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        private ChannelPool channelPool;
        private KeepAliveStrategy keepAliveStrategy = KeepAliveStrategy.DefaultKeepAliveStrategy.INSTANCE;
        private boolean acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        private int handshakeTimeout = AsyncHttpClientConfigDefaults.defaultHandshakeTimeout();
        private String[] enabledProtocols = AsyncHttpClientConfigDefaults.defaultEnabledProtocols();
        private String[] enabledCipherSuites;
        private Integer sslSessionCacheSize = AsyncHttpClientConfigDefaults.defaultSslSessionCacheSize();
        private Integer sslSessionTimeout = AsyncHttpClientConfigDefaults.defaultSslSessionTimeout();
        private SSLContext sslContext;
        private SSLEngineFactory sslEngineFactory;
        private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
        private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
        private final List<IOExceptionFilter> ioExceptionFilters = new LinkedList<IOExceptionFilter>();
        private String threadPoolName = AsyncHttpClientConfigDefaults.defaultThreadPoolName();
        private int httpClientCodecMaxInitialLineLength = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxInitialLineLength();
        private int httpClientCodecMaxHeaderSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxHeaderSize();
        private int httpClientCodecMaxChunkSize = AsyncHttpClientConfigDefaults.defaultHttpClientCodecMaxChunkSize();
        private int chunkedFileChunkSize = AsyncHttpClientConfigDefaults.defaultChunkedFileChunkSize();
        private int webSocketMaxBufferSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxBufferSize();
        private int webSocketMaxFrameSize = AsyncHttpClientConfigDefaults.defaultWebSocketMaxFrameSize();
        private Map<ChannelOption<Object>, Object> channelOptions = new HashMap<ChannelOption<Object>, Object>();
        private EventLoopGroup eventLoopGroup;
        private boolean preferNative;
        private Timer nettyTimer;
        private ThreadFactory threadFactory;
        private AsyncHttpClientConfig.NettyWebSocketFactory nettyWebSocketFactory = AsyncHttpClientConfig.NettyWebSocketFactory.DefaultNettyWebSocketFactory.INSTANCE;
        private AsyncHttpClientConfig.AdditionalPipelineInitializer httpAdditionalPipelineInitializer;
        private AsyncHttpClientConfig.AdditionalPipelineInitializer wsAdditionalPipelineInitializer;
        private AsyncHttpClientConfig.ResponseBodyPartFactory responseBodyPartFactory = AsyncHttpClientConfig.ResponseBodyPartFactory.EAGER;

        public Builder() {
        }

        public Builder(AsyncHttpClientConfig config) {
            this.followRedirect = config.isFollowRedirect();
            this.maxRedirects = config.getMaxRedirects();
            this.strict302Handling = config.isStrict302Handling();
            this.compressionEnforced = config.isCompressionEnforced();
            this.userAgent = config.getUserAgent();
            this.realm = config.getRealm();
            this.maxRequestRetry = config.getMaxRequestRetry();
            this.disableUrlEncodingForBoundRequests = config.isDisableUrlEncodingForBoundRequests();
            this.disableZeroCopy = config.isDisableZeroCopy();
            this.keepEncodingHeader = config.isKeepEncodingHeader();
            this.proxyServerSelector = config.getProxyServerSelector();
            this.connectTimeout = config.getConnectTimeout();
            this.requestTimeout = config.getRequestTimeout();
            this.readTimeout = config.getReadTimeout();
            this.webSocketTimeout = config.getWebSocketTimeout();
            this.shutdownQuietPeriod = config.getShutdownQuietPeriod();
            this.shutdownTimeout = config.getShutdownTimeout();
            this.keepAlive = config.isKeepAlive();
            this.pooledConnectionIdleTimeout = config.getPooledConnectionIdleTimeout();
            this.connectionTtl = config.getConnectionTtl();
            this.maxConnections = config.getMaxConnections();
            this.maxConnectionsPerHost = config.getMaxConnectionsPerHost();
            this.channelPool = config.getChannelPool();
            this.keepAliveStrategy = config.getKeepAliveStrategy();
            this.acceptAnyCertificate = config.isAcceptAnyCertificate();
            this.handshakeTimeout = config.getHandshakeTimeout();
            this.enabledProtocols = config.getEnabledProtocols();
            this.enabledCipherSuites = config.getEnabledCipherSuites();
            this.sslSessionCacheSize = config.getSslSessionCacheSize();
            this.sslSessionTimeout = config.getSslSessionTimeout();
            this.sslContext = config.getSslContext();
            this.sslEngineFactory = config.getSslEngineFactory();
            this.requestFilters.addAll(config.getRequestFilters());
            this.responseFilters.addAll(config.getResponseFilters());
            this.ioExceptionFilters.addAll(config.getIoExceptionFilters());
            this.threadPoolName = config.getThreadPoolName();
            this.httpClientCodecMaxInitialLineLength = config.getHttpClientCodecMaxInitialLineLength();
            this.httpClientCodecMaxHeaderSize = config.getHttpClientCodecMaxHeaderSize();
            this.httpClientCodecMaxChunkSize = config.getHttpClientCodecMaxChunkSize();
            this.chunkedFileChunkSize = config.getChunkedFileChunkSize();
            this.webSocketMaxBufferSize = config.getWebSocketMaxBufferSize();
            this.webSocketMaxFrameSize = config.getWebSocketMaxFrameSize();
            this.channelOptions.putAll(config.getChannelOptions());
            this.eventLoopGroup = config.getEventLoopGroup();
            this.preferNative = config.isPreferNative();
            this.nettyTimer = config.getNettyTimer();
            this.threadFactory = config.getThreadFactory();
            this.nettyWebSocketFactory = config.getNettyWebSocketFactory();
            this.httpAdditionalPipelineInitializer = config.getHttpAdditionalPipelineInitializer();
            this.wsAdditionalPipelineInitializer = config.getWsAdditionalPipelineInitializer();
            this.responseBodyPartFactory = config.getResponseBodyPartFactory();
        }

        public Builder setFollowRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder setStrict302Handling(boolean strict302Handling) {
            this.strict302Handling = strict302Handling;
            return this;
        }

        public Builder setCompressionEnforced(boolean compressionEnforced) {
            this.compressionEnforced = compressionEnforced;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder setRealm(Realm.Builder realmBuilder) {
            this.realm = realmBuilder.build();
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.maxRequestRetry = maxRequestRetry;
            return this;
        }

        public Builder setDisableUrlEncodingForBoundRequests(boolean disableUrlEncodingForBoundRequests) {
            this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
            return this;
        }

        public Builder setDisableZeroCopy(boolean disableZeroCopy) {
            this.disableZeroCopy = disableZeroCopy;
            return this;
        }

        public Builder setKeepEncodingHeader(boolean keepEncodingHeader) {
            this.keepEncodingHeader = keepEncodingHeader;
            return this;
        }

        public Builder setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
            this.proxyServerSelector = proxyServerSelector;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
            return this;
        }

        public Builder setProxyServer(ProxyServer.Builder proxyServerBuilder) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServerBuilder.build());
            return this;
        }

        public Builder setUseProxySelector(boolean useProxySelector) {
            this.useProxySelector = useProxySelector;
            return this;
        }

        public Builder setUseProxyProperties(boolean useProxyProperties) {
            this.useProxyProperties = useProxyProperties;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWebSocketTimeout(int webSocketTimeout) {
            this.webSocketTimeout = webSocketTimeout;
            return this;
        }

        public Builder setShutdownQuietPeriod(int shutdownQuietPeriod) {
            this.shutdownQuietPeriod = shutdownQuietPeriod;
            return this;
        }

        public Builder setShutdownTimeout(int shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
            return this;
        }

        public Builder setConnectionTtl(int connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder setMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public Builder setChannelPool(ChannelPool channelPool) {
            this.channelPool = channelPool;
            return this;
        }

        public Builder setKeepAliveStrategy(KeepAliveStrategy keepAliveStrategy) {
            this.keepAliveStrategy = keepAliveStrategy;
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.acceptAnyCertificate = acceptAnyCertificate;
            return this;
        }

        public Builder setHandshakeTimeout(int handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
            return this;
        }

        public Builder setEnabledProtocols(String[] enabledProtocols) {
            this.enabledProtocols = enabledProtocols;
            return this;
        }

        public Builder setEnabledCipherSuites(String[] enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
            return this;
        }

        public Builder setSslSessionCacheSize(Integer sslSessionCacheSize) {
            this.sslSessionCacheSize = sslSessionCacheSize;
            return this;
        }

        public Builder setSslSessionTimeout(Integer sslSessionTimeout) {
            this.sslSessionTimeout = sslSessionTimeout;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setSslEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
            return this;
        }

        public Builder addRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.add(requestFilter);
            return this;
        }

        public Builder removeRequestFilter(RequestFilter requestFilter) {
            this.requestFilters.remove(requestFilter);
            return this;
        }

        public Builder addResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.add(responseFilter);
            return this;
        }

        public Builder removeResponseFilter(ResponseFilter responseFilter) {
            this.responseFilters.remove(responseFilter);
            return this;
        }

        public Builder addIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.add(ioExceptionFilter);
            return this;
        }

        public Builder removeIOExceptionFilter(IOExceptionFilter ioExceptionFilter) {
            this.ioExceptionFilters.remove(ioExceptionFilter);
            return this;
        }

        public Builder setThreadPoolName(String threadPoolName) {
            this.threadPoolName = threadPoolName;
            return this;
        }

        public Builder setHttpClientCodecMaxInitialLineLength(int httpClientCodecMaxInitialLineLength) {
            this.httpClientCodecMaxInitialLineLength = httpClientCodecMaxInitialLineLength;
            return this;
        }

        public Builder setHttpClientCodecMaxHeaderSize(int httpClientCodecMaxHeaderSize) {
            this.httpClientCodecMaxHeaderSize = httpClientCodecMaxHeaderSize;
            return this;
        }

        public Builder setHttpClientCodecMaxChunkSize(int httpClientCodecMaxChunkSize) {
            this.httpClientCodecMaxChunkSize = httpClientCodecMaxChunkSize;
            return this;
        }

        public Builder setChunkedFileChunkSize(int chunkedFileChunkSize) {
            this.chunkedFileChunkSize = chunkedFileChunkSize;
            return this;
        }

        public Builder setWebSocketMaxBufferSize(int webSocketMaxBufferSize) {
            this.webSocketMaxBufferSize = webSocketMaxBufferSize;
            return this;
        }

        public Builder setWebSocketMaxFrameSize(int webSocketMaxFrameSize) {
            this.webSocketMaxFrameSize = webSocketMaxFrameSize;
            return this;
        }

        public <T> Builder addChannelOption(ChannelOption<T> name, T value) {
            this.channelOptions.put(name, value);
            return this;
        }

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public Builder setPreferNative(boolean preferNative) {
            this.preferNative = preferNative;
            return this;
        }

        public Builder setNettyTimer(Timer nettyTimer) {
            this.nettyTimer = nettyTimer;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setNettyWebSocketFactory(AsyncHttpClientConfig.NettyWebSocketFactory nettyWebSocketFactory) {
            this.nettyWebSocketFactory = nettyWebSocketFactory;
            return this;
        }

        public Builder setHttpAdditionalPipelineInitializer(AsyncHttpClientConfig.AdditionalPipelineInitializer httpAdditionalPipelineInitializer) {
            this.httpAdditionalPipelineInitializer = httpAdditionalPipelineInitializer;
            return this;
        }

        public Builder setWsAdditionalPipelineInitializer(AsyncHttpClientConfig.AdditionalPipelineInitializer wsAdditionalPipelineInitializer) {
            this.wsAdditionalPipelineInitializer = wsAdditionalPipelineInitializer;
            return this;
        }

        public Builder setResponseBodyPartFactory(AsyncHttpClientConfig.ResponseBodyPartFactory responseBodyPartFactory) {
            this.responseBodyPartFactory = responseBodyPartFactory;
            return this;
        }

        private ProxyServerSelector resolveProxyServerSelector() {
            if (this.proxyServerSelector != null) {
                return this.proxyServerSelector;
            }
            if (this.useProxySelector) {
                return ProxyUtils.getJdkDefaultProxyServerSelector();
            }
            if (this.useProxyProperties) {
                return ProxyUtils.createProxyServerSelector(System.getProperties());
            }
            return ProxyServerSelector.NO_PROXY_SELECTOR;
        }

        public DefaultAsyncHttpClientConfig build() {
            return new DefaultAsyncHttpClientConfig(this.followRedirect, this.maxRedirects, this.strict302Handling, this.compressionEnforced, this.userAgent, this.realm, this.maxRequestRetry, this.disableUrlEncodingForBoundRequests, this.disableZeroCopy, this.keepEncodingHeader, this.resolveProxyServerSelector(), this.connectTimeout, this.requestTimeout, this.readTimeout, this.webSocketTimeout, this.shutdownQuietPeriod, this.shutdownTimeout, this.keepAlive, this.pooledConnectionIdleTimeout, this.connectionTtl, this.maxConnections, this.maxConnectionsPerHost, this.channelPool, this.keepAliveStrategy, this.acceptAnyCertificate, this.handshakeTimeout, this.enabledProtocols, this.enabledCipherSuites, this.sslSessionCacheSize, this.sslSessionTimeout, this.sslContext, this.sslEngineFactory, this.requestFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.requestFilters), this.responseFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.responseFilters), this.ioExceptionFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.ioExceptionFilters), this.threadPoolName, this.httpClientCodecMaxInitialLineLength, this.httpClientCodecMaxHeaderSize, this.httpClientCodecMaxChunkSize, this.chunkedFileChunkSize, this.webSocketMaxBufferSize, this.webSocketMaxFrameSize, this.channelOptions.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.channelOptions), this.eventLoopGroup, this.preferNative, this.nettyTimer, this.threadFactory, this.nettyWebSocketFactory, this.httpAdditionalPipelineInitializer, this.wsAdditionalPipelineInitializer, this.responseBodyPartFactory);
        }
    }
}

