/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputStreamBodyGenerator
implements BodyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamBody.class);
    private final InputStream inputStream;

    public InputStreamBodyGenerator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public Body createBody() {
        return new InputStreamBody(this.inputStream);
    }

    private class InputStreamBody
    implements Body {
        private final InputStream inputStream;
        private byte[] chunk;

        private InputStreamBody(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.BodyState transferTo(ByteBuffer buffer) throws IOException {
            this.chunk = new byte[buffer.remaining() - 10];
            int read = -1;
            boolean write = false;
            try {
                read = this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to read", (Throwable)ex);
            }
            if (read > 0) {
                buffer.put(this.chunk, 0, read);
                write = true;
            }
            return write ? Body.BodyState.CONTINUE : Body.BodyState.STOP;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

