/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;

public final class SimpleFeedableBodyGenerator
implements FeedableBodyGenerator,
BodyGenerator {
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private FeedableBodyGenerator.FeedListener listener;

    @Override
    public Body createBody() {
        return new PushBody();
    }

    @Override
    public void feed(ByteBuffer buffer, boolean isLast) {
        this.queue.offer(new BodyPart(buffer, isLast));
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    @Override
    public void setListener(FeedableBodyGenerator.FeedListener listener) {
        this.listener = listener;
    }

    private void move(ByteBuffer destination, ByteBuffer source) {
        int size = Math.min(destination.remaining(), source.remaining());
        if (size > 0) {
            ByteBuffer slice = source.slice();
            slice.limit(size);
            destination.put(slice);
            source.position(source.position() + size);
        }
    }

    private final class BodyPart {
        private final boolean isLast;
        private final ByteBuffer buffer;

        public BodyPart(ByteBuffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }
    }

    public final class PushBody
    implements Body {
        private Body.BodyState state = Body.BodyState.CONTINUE;

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.BodyState transferTo(ByteBuffer buffer) throws IOException {
            switch (this.state) {
                case CONTINUE: {
                    return this.readNextPart(buffer);
                }
                case STOP: {
                    return Body.BodyState.STOP;
                }
            }
            throw new IllegalStateException("Illegal process state.");
        }

        private Body.BodyState readNextPart(ByteBuffer buffer) throws IOException {
            Body.BodyState res = Body.BodyState.SUSPEND;
            while (buffer.hasRemaining() && this.state != Body.BodyState.STOP) {
                BodyPart nextPart = (BodyPart)SimpleFeedableBodyGenerator.this.queue.peek();
                if (nextPart == null) {
                    return res;
                }
                if (!nextPart.buffer.hasRemaining() && !nextPart.isLast) {
                    SimpleFeedableBodyGenerator.this.queue.remove();
                    continue;
                }
                res = Body.BodyState.CONTINUE;
                this.readBodyPart(buffer, nextPart);
            }
            return res;
        }

        private void readBodyPart(ByteBuffer buffer, BodyPart part) {
            SimpleFeedableBodyGenerator.this.move(buffer, part.buffer);
            if (!part.buffer.hasRemaining()) {
                if (part.isLast) {
                    this.state = Body.BodyState.STOP;
                }
                SimpleFeedableBodyGenerator.this.queue.remove();
            }
        }

        @Override
        public void close() {
        }
    }
}

