/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;
import org.asynchttpclient.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartBody
implements RandomAccessBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartBody.class);
    private final List<MultipartPart<? extends Part>> parts;
    private final String contentType;
    private final byte[] boundary;
    private final long contentLength;
    private int currentPartIndex;
    private boolean done = false;

    public MultipartBody(List<MultipartPart<? extends Part>> parts, String contentType, byte[] boundary) {
        Assertions.assertNotNull(parts, "parts");
        this.boundary = boundary;
        this.contentType = contentType;
        this.parts = parts;
        this.contentLength = this.computeContentLength();
    }

    private long computeContentLength() {
        try {
            long total = 0L;
            for (MultipartPart<? extends Part> part : this.parts) {
                long l = part.length();
                if (l < 0L) {
                    return -1L;
                }
                total += l;
            }
            return total;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public void close() throws IOException {
        for (MultipartPart<? extends Part> part : this.parts) {
            part.close();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    @Override
    public Body.BodyState transferTo(ByteBuffer target) throws IOException {
        if (this.done) {
            return Body.BodyState.STOP;
        }
        while (target.hasRemaining() && !this.done) {
            MultipartPart<? extends Part> currentPart = this.parts.get(this.currentPartIndex);
            currentPart.transferTo(target);
            if (currentPart.getState() != MultipartState.DONE) continue;
            ++this.currentPartIndex;
            if (this.currentPartIndex != this.parts.size()) continue;
            this.done = true;
        }
        return Body.BodyState.CONTINUE;
    }

    @Override
    public long transferTo(long position, WritableByteChannel target) throws IOException {
        long transferred;
        MultipartPart<? extends Part> currentPart;
        if (this.done) {
            return -1L;
        }
        boolean slowTarget = false;
        for (transferred = 0L; transferred < 8192L && !this.done && !slowTarget; transferred += currentPart.transferTo(target)) {
            currentPart = this.parts.get(this.currentPartIndex);
            slowTarget = currentPart.isTargetSlow();
            if (currentPart.getState() != MultipartState.DONE) continue;
            ++this.currentPartIndex;
            if (this.currentPartIndex != this.parts.size()) continue;
            this.done = true;
        }
        return transferred;
    }
}

