/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;

public class FileMultipartPart
extends MultipartPart<FilePart> {
    private final FileChannel channel;
    private final long length;
    private long position = 0L;

    public FileMultipartPart(FilePart part, byte[] boundary) {
        super(part, boundary);
        try {
            this.channel = new FileInputStream(part.getFile()).getChannel();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File part doesn't exist: " + part.getFile().getAbsolutePath(), e);
        }
        this.length = part.getFile().length();
    }

    @Override
    protected long getContentLength() {
        return ((FilePart)this.part).getFile().length();
    }

    @Override
    protected long transferContentTo(ByteBuffer target) throws IOException {
        int transferred = this.channel.read(target);
        this.position += (long)transferred;
        if (this.position == this.length) {
            this.state = MultipartState.POST_CONTENT;
            this.channel.close();
        }
        return transferred;
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        long transferred = this.channel.transferTo(this.channel.position(), 8192L, target);
        this.position += transferred;
        if (this.position == this.length) {
            this.state = MultipartState.POST_CONTENT;
            this.channel.close();
        } else {
            this.slowTarget = true;
        }
        return transferred;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

