/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;

public class MessageEndMultipartPart
extends MultipartPart<FileLikePart> {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final ByteBuffer buffer = ByteBuffer.allocate((int)this.length());

    public MessageEndMultipartPart(byte[] boundary) {
        super(null, boundary);
        this.buffer.put(Part.EXTRA_BYTES).put(boundary).put(Part.EXTRA_BYTES).put(Part.CRLF_BYTES);
        this.buffer.flip();
        this.state = MultipartState.PRE_CONTENT;
    }

    @Override
    public long transferTo(ByteBuffer target) throws IOException {
        return this.transfer(this.buffer, target, MultipartState.DONE);
    }

    @Override
    public long transferTo(WritableByteChannel target) throws IOException {
        this.slowTarget = false;
        return this.transfer(this.buffer, target, MultipartState.DONE);
    }

    @Override
    protected ByteBuffer computePreContentBytes() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    protected ByteBuffer computePostContentBytes() {
        return EMPTY_BYTE_BUFFER;
    }

    @Override
    protected long getContentLength() {
        return Part.EXTRA_BYTES.length + this.boundary.length + Part.EXTRA_BYTES.length + Part.CRLF_BYTES.length;
    }

    @Override
    protected long transferContentTo(ByteBuffer target) throws IOException {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    public void close() {
    }
}

