/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.FileLikePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;

public class MessageEndMultipartPart
extends MultipartPart<FileLikePart> {
    private final ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer((int)this.length());

    public MessageEndMultipartPart(byte[] boundary) {
        super(null, boundary);
        this.buffer.writeBytes(Part.EXTRA_BYTES).writeBytes(boundary).writeBytes(Part.EXTRA_BYTES).writeBytes(Part.CRLF_BYTES);
        this.state = MultipartState.PRE_CONTENT;
    }

    @Override
    public long transferTo(ByteBuf target) throws IOException {
        return this.transfer(this.buffer, target, MultipartState.DONE);
    }

    @Override
    public long transferTo(WritableByteChannel target) throws IOException {
        this.slowTarget = false;
        return this.transfer(this.buffer, target, MultipartState.DONE);
    }

    @Override
    protected ByteBuf computePreContentBytes() {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected ByteBuf computePostContentBytes() {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected long getContentLength() {
        return Part.EXTRA_BYTES.length + this.boundary.length + Part.EXTRA_BYTES.length + Part.CRLF_BYTES.length;
    }

    @Override
    protected long transferContentTo(ByteBuf target) throws IOException {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    public void close() {
        this.buffer.release();
    }
}

