/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.resolver;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleGenericFutureListener;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;

public enum RequestNameResolver {
    INSTANCE;


    public Future<List<InetSocketAddress>> resolve(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        int port;
        String name;
        AsyncHandlerExtensions asyncHandlerExtensions;
        Uri uri = request.getUri();
        if (request.getAddress() != null) {
            List<InetSocketAddress> resolved = Collections.singletonList(new InetSocketAddress(request.getAddress(), uri.getExplicitPort()));
            Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
            return promise.setSuccess(resolved);
        }
        AsyncHandlerExtensions asyncHandlerExtensions2 = asyncHandlerExtensions = request.getAddress() == null ? AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler) : null;
        if (proxy != null && !proxy.isIgnoredForHost(uri.getHost())) {
            name = proxy.getHost();
            port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
        } else {
            name = uri.getHost();
            port = uri.getExplicitPort();
        }
        if (asyncHandlerExtensions != null) {
            asyncHandlerExtensions.onDnsResolution(name);
        }
        Future<List<InetSocketAddress>> whenResolved = request.getNameResolver().resolve(name, port);
        if (asyncHandlerExtensions == null) {
            return whenResolved;
        }
        final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        whenResolved.addListener((GenericFutureListener)new SimpleGenericFutureListener<List<InetSocketAddress>>(){

            @Override
            protected void onSuccess(List<InetSocketAddress> addresses) throws Exception {
                asyncHandlerExtensions.onDnsResolutionSuccess(name, addresses);
                promise.setSuccess(addresses);
            }

            @Override
            protected void onFailure(Throwable t) throws Exception {
                asyncHandlerExtensions.onDnsResolutionFailure(name, t);
                promise.setFailure(t);
            }
        });
        return promise;
    }
}

