/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.DiscardEvent;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.asynchttpclient.netty.handler.Protocol;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class AsyncHttpClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHttpClientHandler.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final Protocol protocol;

    public AsyncHttpClientHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender, Protocol protocol) {
        this.config = config;
        this.channelManager = channelManager;
        this.requestSender = requestSender;
        this.protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        Object attribute = Channels.getAttribute(channel);
        try {
            if (attribute instanceof Callback) {
                Callback ac = (Callback)attribute;
                if (msg instanceof LastHttpContent) {
                    ac.call();
                } else if (!(msg instanceof HttpContent)) {
                    LOGGER.info("Received unexpected message while expecting a chunk: " + msg);
                    ac.call();
                    Channels.setDiscard(channel);
                }
            } else if (attribute instanceof NettyResponseFuture) {
                NettyResponseFuture future = (NettyResponseFuture)attribute;
                this.protocol.handle(channel, future, msg);
            } else if (attribute instanceof StreamedResponsePublisher) {
                StreamedResponsePublisher publisher = (StreamedResponsePublisher)((Object)attribute);
                if (msg instanceof HttpContent) {
                    ByteBuf content = ((HttpContent)msg).content();
                    if (content.readableBytes() > 0) {
                        HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(content, false);
                        ctx.fireChannelRead((Object)part);
                    }
                    if (msg instanceof LastHttpContent) {
                        ctx.pipeline().remove((ChannelHandler)publisher);
                        ctx.read();
                        this.protocol.handle(channel, publisher.future(), msg);
                    }
                } else {
                    LOGGER.info("Received unexpected message while expecting a chunk: " + msg);
                    ctx.pipeline().remove((ChannelHandler)((StreamedResponsePublisher)((Object)attribute)));
                    Channels.setDiscard(channel);
                }
            } else if (attribute != DiscardEvent.INSTANCE) {
                LOGGER.debug("Orphan channel {} with attribute {} received message {}, closing", new Object[]{channel, attribute, msg});
                Channels.silentlyCloseChannel(channel);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.requestSender.isClosed()) {
            return;
        }
        Channel channel = ctx.channel();
        this.channelManager.removeAll(channel);
        try {
            super.channelInactive(ctx);
        }
        catch (Exception ex) {
            LOGGER.trace("super.channelClosed", (Throwable)ex);
        }
        NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
        LOGGER.debug("Channel Closed: {} with attribute {}", (Object)channel, (Object)attribute);
        if (attribute instanceof StreamedResponsePublisher) {
            attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
        }
        if (attribute instanceof Callback) {
            Callback callback = (Callback)((Object)attribute);
            Channels.setAttribute(channel, callback.future());
            callback.call();
        } else if (attribute instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)NettyResponseFuture.class.cast(attribute);
            future.touch();
            if (!this.config.getIoExceptionFilters().isEmpty() && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, HttpUtils.CHANNEL_CLOSED_EXCEPTION, channel)) {
                return;
            }
            this.protocol.onClose(future);
            this.requestSender.handleUnexpectedClosedChannel(channel, future);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        Throwable cause = MiscUtils.getCause(e.getCause());
        if (cause instanceof PrematureChannelClosureException || cause instanceof ClosedChannelException) {
            return;
        }
        Channel channel = ctx.channel();
        NettyResponseFuture<?> future = null;
        LOGGER.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
        try {
            NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
            if (attribute instanceof StreamedResponsePublisher) {
                ctx.fireExceptionCaught(e);
                attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
            }
            if (attribute instanceof NettyResponseFuture) {
                future = attribute;
                future.attachChannel(null, false);
                future.touch();
                if (cause instanceof IOException && !this.config.getIoExceptionFilters().isEmpty()) {
                    if (!this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, HttpUtils.CHANNEL_CLOSED_EXCEPTION, channel)) {
                        Channels.silentlyCloseChannel(channel);
                    }
                    return;
                }
                if (StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                    LOGGER.debug("Trying to recover from dead Channel: {}", (Object)channel);
                    return;
                }
            } else if (attribute instanceof Callback) {
                future = ((Callback)Callback.class.cast(attribute)).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future != null) {
            try {
                LOGGER.debug("Was unable to recover Future: {}", future);
                this.requestSender.abort(channel, future, cause);
                this.protocol.onError(future, e);
            }
            catch (Throwable t) {
                LOGGER.error(t.getMessage(), t);
            }
        }
        this.channelManager.closeChannel(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.isHandledByReactiveStreams(ctx)) {
            ctx.read();
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private boolean isHandledByReactiveStreams(ChannelHandlerContext ctx) {
        return Channels.getAttribute(ctx.channel()) instanceof StreamedResponsePublisher;
    }
}

