/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.oauth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilderBase;
import org.asynchttpclient.oauth.ConsumerKey;
import org.asynchttpclient.oauth.Parameters;
import org.asynchttpclient.oauth.RequestToken;
import org.asynchttpclient.util.Base64;
import org.asynchttpclient.util.StringBuilderPool;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.util.Utf8UrlEncoder;

class OAuthSignatureCalculatorInstance {
    private static final Pattern STAR_CHAR_PATTERN = Pattern.compile("*", 16);
    private static final Pattern PLUS_CHAR_PATTERN = Pattern.compile("+", 16);
    private static final Pattern ENCODED_TILDE_PATTERN = Pattern.compile("%7E", 16);
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;
    private final byte[] nonceBuffer = new byte[16];
    private final Parameters parameters = new Parameters();

    public OAuthSignatureCalculatorInstance() throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
    }

    public void sign(ConsumerKey consumerAuth, RequestToken userAuth, Request request, RequestBuilderBase<?> requestBuilder) throws InvalidKeyException {
        String nonce = this.generateNonce();
        long timestamp = OAuthSignatureCalculatorInstance.generateTimestamp();
        this.sign(consumerAuth, userAuth, request, requestBuilder, nonce, timestamp);
    }

    private String generateNonce() {
        ThreadLocalRandom.current().nextBytes(this.nonceBuffer);
        return Base64.encode(this.nonceBuffer);
    }

    private static long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    void sign(ConsumerKey consumerAuth, RequestToken userAuth, Request request, RequestBuilderBase<?> requestBuilder, String nonce, long timestamp) throws InvalidKeyException {
        String signature = this.calculateSignature(consumerAuth, userAuth, request, timestamp, nonce);
        String headerValue = this.constructAuthHeader(consumerAuth, userAuth, signature, nonce, timestamp);
        requestBuilder.setHeader((CharSequence)"Authorization", headerValue);
    }

    String calculateSignature(ConsumerKey consumerAuth, RequestToken userAuth, Request request, long oauthTimestamp, String nonce) throws InvalidKeyException {
        StringBuilder sb = this.signatureBaseString(consumerAuth, userAuth, request, oauthTimestamp, nonce);
        ByteBuffer rawBase = StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.UTF_8);
        byte[] rawSignature = this.digest(consumerAuth, userAuth, rawBase);
        return Base64.encode(rawSignature);
    }

    StringBuilder signatureBaseString(ConsumerKey consumerAuth, RequestToken userAuth, Request request, long oauthTimestamp, String nonce) {
        String baseUrl = request.getUri().toBaseUrl();
        String encodedParams = this.encodedParams(consumerAuth, userAuth, oauthTimestamp, nonce, request.getFormParams(), request.getQueryParams());
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(request.getMethod());
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, baseUrl);
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, encodedParams);
        return sb;
    }

    private String encodedParams(ConsumerKey consumerAuth, RequestToken userAuth, long oauthTimestamp, String nonce, List<Param> formParams, List<Param> queryParams) {
        this.parameters.reset();
        this.parameters.add(KEY_OAUTH_CONSUMER_KEY, Utf8UrlEncoder.percentEncodeQueryElement(consumerAuth.getKey())).add(KEY_OAUTH_NONCE, Utf8UrlEncoder.percentEncodeQueryElement(nonce)).add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD).add(KEY_OAUTH_TIMESTAMP, String.valueOf(oauthTimestamp));
        if (userAuth.getKey() != null) {
            this.parameters.add(KEY_OAUTH_TOKEN, Utf8UrlEncoder.percentEncodeQueryElement(userAuth.getKey()));
        }
        this.parameters.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (formParams != null) {
            for (Param param : formParams) {
                this.parameters.add(Utf8UrlEncoder.percentEncodeQueryElement(param.getName()), Utf8UrlEncoder.percentEncodeQueryElement(param.getValue()));
            }
        }
        if (queryParams != null) {
            for (Param param : queryParams) {
                this.parameters.add(this.percentEncodeAlreadyFormUrlEncoded(param.getName()), this.percentEncodeAlreadyFormUrlEncoded(param.getValue()));
            }
        }
        return this.parameters.sortAndConcat();
    }

    private String percentEncodeAlreadyFormUrlEncoded(String s) {
        s = STAR_CHAR_PATTERN.matcher(s).replaceAll("%2A");
        s = PLUS_CHAR_PATTERN.matcher(s).replaceAll("%20");
        s = ENCODED_TILDE_PATTERN.matcher(s).replaceAll("~");
        return s;
    }

    private byte[] digest(ConsumerKey consumerAuth, RequestToken userAuth, ByteBuffer message) throws InvalidKeyException {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, consumerAuth.getSecret());
        sb.append('&');
        if (userAuth != null && userAuth.getSecret() != null) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(sb, userAuth.getSecret());
        }
        byte[] keyBytes = StringUtils.charSequence2Bytes(sb, StandardCharsets.UTF_8);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        this.mac.init(signingKey);
        this.mac.reset();
        this.mac.update(message);
        return this.mac.doFinal();
    }

    String constructAuthHeader(ConsumerKey consumerAuth, RequestToken userAuth, String signature, String nonce, long oauthTimestamp) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append("OAuth ");
        sb.append(KEY_OAUTH_CONSUMER_KEY).append("=\"").append(consumerAuth.getKey()).append("\", ");
        if (userAuth.getKey() != null) {
            sb.append(KEY_OAUTH_TOKEN).append("=\"").append(userAuth.getKey()).append("\", ");
        }
        sb.append(KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAUTH_SIGNATURE_METHOD).append("\", ");
        sb.append(KEY_OAUTH_SIGNATURE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, signature).append("\", ");
        sb.append(KEY_OAUTH_TIMESTAMP).append("=\"").append(oauthTimestamp).append("\", ");
        sb.append(KEY_OAUTH_NONCE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, nonce);
        sb.append("\", ");
        sb.append(KEY_OAUTH_VERSION).append("=\"").append(OAUTH_VERSION_1_0).append("\"");
        return sb.toString();
    }
}

