/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringBuilderPool;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.util.Utf8UrlEncoder;

public class HttpUtils {
    private static final String CONTENT_TYPE_CHARSET_ATTRIBUTE = "charset=";

    public static void validateSupportedScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + uri + ", must be equal (ignoring case) to 'http', 'https', 'ws', or 'wss'");
        }
    }

    public static String getBaseUrl(Uri uri) {
        return uri.getScheme() + "://" + uri.getHost() + ":" + uri.getExplicitPort();
    }

    public static String getAuthority(Uri uri) {
        return uri.getHost() + ":" + uri.getExplicitPort();
    }

    public static boolean isSameBase(Uri uri1, Uri uri2) {
        return uri1.getScheme().equals(uri2.getScheme()) && uri1.getHost().equals(uri2.getHost()) && uri1.getExplicitPort() == uri2.getExplicitPort();
    }

    public static String getNonEmptyPath(Uri uri) {
        return MiscUtils.isNonEmpty(uri.getPath()) ? uri.getPath() : "/";
    }

    public static Charset extractCharset(String contentType) {
        if (contentType != null) {
            for (int i = 0; i < contentType.length(); ++i) {
                char c;
                int end;
                char c2;
                int start;
                if (!contentType.regionMatches(true, i, CONTENT_TYPE_CHARSET_ATTRIBUTE, 0, CONTENT_TYPE_CHARSET_ATTRIBUTE.length())) continue;
                for (start = i + CONTENT_TYPE_CHARSET_ATTRIBUTE.length(); start < contentType.length() && ((c2 = contentType.charAt(start)) == ' ' || c2 == '\'' || c2 == '\"'); ++start) {
                }
                if (start == contentType.length()) break;
                for (end = start + 1; end < contentType.length() && (c = contentType.charAt(end)) != ' ' && c != '\'' && c != '\"' && c != ';'; ++end) {
                }
                String charsetName = contentType.substring(start, end);
                return Charset.forName(charsetName);
            }
        }
        return null;
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request) {
        return request.getFollowRedirect() != null ? request.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static ByteBuffer urlEncodeFormParams(List<Param> params, Charset charset) {
        return StringUtils.charSequence2ByteBuffer(HttpUtils.urlEncodeFormParams0(params, charset), StandardCharsets.US_ASCII);
    }

    private static StringBuilder urlEncodeFormParams0(List<Param> params, Charset charset) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        for (Param param : params) {
            HttpUtils.encodeAndAppendFormParam(sb, param.getName(), param.getValue(), charset);
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static void encodeAndAppendFormParam(StringBuilder sb, String name, String value, Charset charset) {
        HttpUtils.encodeAndAppendFormField(sb, name, charset);
        if (value != null) {
            sb.append('=');
            HttpUtils.encodeAndAppendFormField(sb, value, charset);
        }
        sb.append('&');
    }

    private static void encodeAndAppendFormField(StringBuilder sb, String field, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            Utf8UrlEncoder.encodeAndAppendFormElement(sb, field);
        } else {
            try {
                sb.append(URLEncoder.encode(field, charset.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public static String hostHeader(Request request, Uri uri) {
        String virtualHost = request.getVirtualHost();
        if (virtualHost != null) {
            return virtualHost;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        return port == -1 || port == uri.getSchemeDefaultPort() ? host : host + ":" + port;
    }

    public static String computeOriginHeader(Uri uri) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(uri.isSecured() ? "https://" : "http://").append(uri.getHost());
        if (uri.getExplicitPort() != uri.getSchemeDefaultPort()) {
            sb.append(':').append(uri.getPort());
        }
        return sb.toString();
    }

    public static class ContentType {
        public final String value;
        public final Charset charset;

        public ContentType(String value, Charset charset) {
            this.value = value;
            this.charset = charset;
        }
    }
}

