/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.exception.TooManyConnectionsException;
import org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;

public class ConnectionSemaphore {
    private final int maxTotalConnections;
    private final NonBlockingSemaphoreLike freeChannels;
    private final int maxConnectionsPerHost;
    private final ConcurrentHashMap<Object, NonBlockingSemaphore> freeChannelsPerHost = new ConcurrentHashMap();
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;

    public ConnectionSemaphore(AsyncHttpClientConfig config) {
        this.tooManyConnections = (IOException)ThrowableUtil.unknownStackTrace((Throwable)new TooManyConnectionsException(config.getMaxConnections()), ConnectionSemaphore.class, (String)"acquireChannelLock");
        this.tooManyConnectionsPerHost = (IOException)ThrowableUtil.unknownStackTrace((Throwable)new TooManyConnectionsPerHostException(config.getMaxConnectionsPerHost()), ConnectionSemaphore.class, (String)"acquireChannelLock");
        this.maxTotalConnections = config.getMaxConnections();
        this.maxConnectionsPerHost = config.getMaxConnectionsPerHost();
        this.freeChannels = this.maxTotalConnections > 0 ? new NonBlockingSemaphore(config.getMaxConnections()) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    private boolean tryAcquireGlobal() {
        return this.freeChannels.tryAcquire();
    }

    private NonBlockingSemaphoreLike getFreeConnectionsForHost(Object partitionKey) {
        return this.maxConnectionsPerHost > 0 ? (NonBlockingSemaphoreLike)this.freeChannelsPerHost.computeIfAbsent(partitionKey, pk -> new NonBlockingSemaphore(this.maxConnectionsPerHost)) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void acquireChannelLock(Object partitionKey) throws IOException {
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            this.freeChannels.release();
            throw this.tooManyConnectionsPerHost;
        }
    }

    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
        this.getFreeConnectionsForHost(partitionKey).release();
    }
}

