/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.util.AsciiString;
import java.nio.charset.Charset;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.netty.request.body.NettyBodyBody;
import org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyDirectBody;
import org.asynchttpclient.netty.request.body.NettyFileBody;
import org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import org.asynchttpclient.netty.request.body.NettyMultipartBody;
import org.asynchttpclient.netty.request.body.NettyReactiveStreamsBody;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.FileBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.ws.WebSocketUtils;

public final class NettyRequestFactory {
    public static final String BROTLY_ACCEPT_ENCODING_SUFFIX = ", br";
    public static final String GZIP_DEFLATE = HttpHeaderValues.GZIP + "," + HttpHeaderValues.DEFLATE;
    private final AsyncHttpClientConfig config;
    private final ClientCookieEncoder cookieEncoder;

    public NettyRequestFactory(AsyncHttpClientConfig config) {
        this.config = config;
        this.cookieEncoder = config.isUseLaxCookieEncoder() ? ClientCookieEncoder.LAX : ClientCookieEncoder.STRICT;
    }

    private NettyBody body(Request request) {
        NettyBody nettyBody = null;
        Charset bodyCharset = MiscUtils.withDefault(request.getCharset(), HttpUtils.DEFAULT_CHARSET);
        if (request.getByteData() != null) {
            nettyBody = new NettyByteArrayBody(request.getByteData());
        } else if (request.getCompositeByteData() != null) {
            nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
        } else if (request.getStringData() != null) {
            nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request.getStringData(), bodyCharset));
        } else if (request.getByteBufferData() != null) {
            nettyBody = new NettyByteBufferBody(request.getByteBufferData());
        } else if (request.getStreamData() != null) {
            nettyBody = new NettyInputStreamBody(request.getStreamData());
        } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
            AsciiString contentTypeOverride = request.getHeaders().contains((CharSequence)HttpHeaderNames.CONTENT_TYPE) ? null : HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED;
            nettyBody = new NettyByteBufferBody(HttpUtils.urlEncodeFormParams(request.getFormParams(), bodyCharset), (CharSequence)contentTypeOverride);
        } else if (MiscUtils.isNonEmpty(request.getBodyParts())) {
            nettyBody = new NettyMultipartBody(request.getBodyParts(), request.getHeaders(), this.config);
        } else if (request.getFile() != null) {
            nettyBody = new NettyFileBody(request.getFile(), this.config);
        } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
            FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
            nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
        } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
            InputStreamBodyGenerator inStreamGenerator = (InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator());
            nettyBody = new NettyInputStreamBody(inStreamGenerator.getInputStream(), inStreamGenerator.getContentLength());
        } else if (request.getBodyGenerator() instanceof ReactiveStreamsBodyGenerator) {
            ReactiveStreamsBodyGenerator reactiveStreamsBodyGenerator = (ReactiveStreamsBodyGenerator)request.getBodyGenerator();
            nettyBody = new NettyReactiveStreamsBody(reactiveStreamsBodyGenerator.getPublisher(), reactiveStreamsBodyGenerator.getContentLength());
        } else if (request.getBodyGenerator() != null) {
            nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.config);
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, boolean forceConnect, ProxyServer proxyServer, Realm realm, Realm proxyRealm) {
        CharSequence connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultFullHttpRequest httpRequest;
        NettyBody body;
        Uri uri = request.getUri();
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf((String)request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody nettyBody = body = connect ? null : this.body(request);
        if (body == null) {
            httpRequest = new DefaultFullHttpRequest(httpVersion, method, requestUri, Unpooled.EMPTY_BUFFER);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, null);
        } else if (body instanceof NettyDirectBody) {
            ByteBuf buf = ((NettyDirectBody)NettyDirectBody.class.cast(body)).byteBuf();
            DefaultFullHttpRequest httpRequest2 = new DefaultFullHttpRequest(httpVersion, method, requestUri, buf);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest2, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, body);
        }
        HttpHeaders headers = nettyRequest.getHttpRequest().headers();
        if (connect) {
            headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Iterable)request.getHeaders().getAll((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION));
        } else {
            String userDefinedAcceptEncoding;
            headers.set(request.getHeaders());
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode(request.getCookies()));
            }
            if ((userDefinedAcceptEncoding = headers.get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) != null) {
                if (userDefinedAcceptEncoding.endsWith(BROTLY_ACCEPT_ENCODING_SUFFIX)) {
                    headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)userDefinedAcceptEncoding.subSequence(0, userDefinedAcceptEncoding.length() - BROTLY_ACCEPT_ENCODING_SUFFIX.length()));
                }
            } else if (this.config.isCompressionEnforced()) {
                headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                if (body.getContentLength() < 0L) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.getContentLength());
                }
            }
            if (body.getContentTypeOverride() != null) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)body.getContentTypeOverride());
            }
        }
        if (!connect && uri.isWebSocket()) {
            headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)WebSocketUtils.getKey()).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
            if (!headers.contains((CharSequence)HttpHeaderNames.ORIGIN)) {
                headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)HttpUtils.computeOriginHeader(uri));
            }
        } else if (!headers.contains((CharSequence)HttpHeaderNames.CONNECTION) && (connectionHeaderValue = this.connectionHeader(this.config.isKeepAlive(), httpVersion)) != null) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connectionHeaderValue);
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)HttpUtils.hostHeader(request, uri));
        }
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(request, realm));
        if (!uri.isSecured() || connect) {
            this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(request, proxyRealm));
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.ACCEPT)) {
            headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT) && this.config.getUserAgent() != null) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return HttpUtils.getAuthority(uri);
        }
        if (proxyServer != null && !uri.isSecured()) {
            return uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        return MiscUtils.isNonEmpty(uri.getQuery()) ? path + "?" + uri.getQuery() : path;
    }

    private CharSequence connectionHeader(boolean keepAlive, HttpVersion httpVersion) {
        if (httpVersion.isKeepAliveDefault()) {
            return keepAlive ? null : HttpHeaderValues.CLOSE;
        }
        return keepAlive ? HttpHeaderValues.KEEP_ALIVE : null;
    }
}

