/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ssl;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.util.MiscUtils;

public abstract class SslEngineFactoryBase
implements SslEngineFactory {
    protected void configureSslEngine(SSLEngine sslEngine, AsyncHttpClientConfig config) {
        sslEngine.setUseClientMode(true);
        if (!config.isDisableHttpsAlgorithm()) {
            SSLParameters params = sslEngine.getSSLParameters();
            params.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(params);
        }
        if (MiscUtils.isNonEmpty(config.getEnabledProtocols())) {
            sslEngine.setEnabledProtocols(config.getEnabledProtocols());
        }
        if (MiscUtils.isNonEmpty(config.getEnabledCipherSuites())) {
            sslEngine.setEnabledCipherSuites(config.getEnabledCipherSuites());
        }
    }
}

