/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.MessageDigestUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringBuilderPool;
import org.asynchttpclient.util.StringUtils;

public class Realm {
    private static final String DEFAULT_NC = "00000001";
    private static final String EMPTY_ENTITY_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    private final String principal;
    private final String password;
    private final AuthScheme scheme;
    private final String realmName;
    private final String nonce;
    private final String algorithm;
    private final String response;
    private final String opaque;
    private final String qop;
    private final String nc;
    private final String cnonce;
    private final Uri uri;
    private final boolean usePreemptiveAuth;
    private final Charset charset;
    private final String ntlmHost;
    private final String ntlmDomain;
    private final boolean useAbsoluteURI;
    private final boolean omitQuery;
    private final Map<String, String> customLoginConfig;
    private final String servicePrincipalName;
    private final boolean useCanonicalHostname;
    private final String loginContextName;

    private Realm(AuthScheme scheme, String principal, String password, String realmName, String nonce, String algorithm, String response, String opaque, String qop, String nc, String cnonce, Uri uri, boolean usePreemptiveAuth, Charset charset, String ntlmDomain, String ntlmHost, boolean useAbsoluteURI, boolean omitQuery, String servicePrincipalName, boolean useCanonicalHostname, Map<String, String> customLoginConfig, String loginContextName) {
        this.scheme = Assertions.assertNotNull(scheme, "scheme");
        this.principal = principal;
        this.password = password;
        this.realmName = realmName;
        this.nonce = nonce;
        this.algorithm = algorithm;
        this.response = response;
        this.opaque = opaque;
        this.qop = qop;
        this.nc = nc;
        this.cnonce = cnonce;
        this.uri = uri;
        this.usePreemptiveAuth = usePreemptiveAuth;
        this.charset = charset;
        this.ntlmDomain = ntlmDomain;
        this.ntlmHost = ntlmHost;
        this.useAbsoluteURI = useAbsoluteURI;
        this.omitQuery = omitQuery;
        this.servicePrincipalName = servicePrincipalName;
        this.useCanonicalHostname = useCanonicalHostname;
        this.customLoginConfig = customLoginConfig;
        this.loginContextName = loginContextName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isUsePreemptiveAuth() {
        return this.usePreemptiveAuth;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getNtlmHost() {
        return this.ntlmHost;
    }

    public boolean isUseAbsoluteURI() {
        return this.useAbsoluteURI;
    }

    public boolean isOmitQuery() {
        return this.omitQuery;
    }

    public Map<String, String> getCustomLoginConfig() {
        return this.customLoginConfig;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    public String toString() {
        return "Realm{principal='" + this.principal + "', password='" + this.password + "', scheme=" + this.scheme + ", realmName='" + this.realmName + "', nonce='" + this.nonce + "', algorithm='" + this.algorithm + "', response='" + this.response + "', opaque='" + this.opaque + "', qop='" + this.qop + "', nc='" + this.nc + "', cnonce='" + this.cnonce + "', uri=" + this.uri + ", usePreemptiveAuth=" + this.usePreemptiveAuth + ", charset=" + this.charset + ", ntlmHost='" + this.ntlmHost + "', ntlmDomain='" + this.ntlmDomain + "', useAbsoluteURI=" + this.useAbsoluteURI + ", omitQuery=" + this.omitQuery + ", customLoginConfig=" + this.customLoginConfig + ", servicePrincipalName='" + this.servicePrincipalName + "', useCanonicalHostname=" + this.useCanonicalHostname + ", loginContextName='" + this.loginContextName + "'}";
    }

    public static class Builder {
        private final String principal;
        private final String password;
        private AuthScheme scheme;
        private String realmName;
        private String nonce;
        private String algorithm;
        private String response;
        private String opaque;
        private String qop;
        private String nc = "00000001";
        private String cnonce;
        private Uri uri;
        private String methodName = "GET";
        private boolean usePreemptive;
        private String ntlmDomain = System.getProperty("http.auth.ntlm.domain");
        private Charset charset = StandardCharsets.UTF_8;
        private String ntlmHost = "localhost";
        private boolean useAbsoluteURI;
        private boolean omitQuery;
        private Map<String, String> customLoginConfig;
        private String servicePrincipalName;
        private boolean useCanonicalHostname;
        private String loginContextName;

        public Builder() {
            this.principal = null;
            this.password = null;
        }

        public Builder(String principal, String password) {
            this.principal = principal;
            this.password = password;
        }

        public Builder setNtlmDomain(String ntlmDomain) {
            this.ntlmDomain = ntlmDomain;
            return this;
        }

        public Builder setNtlmHost(String host) {
            this.ntlmHost = host;
            return this;
        }

        public Builder setScheme(AuthScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setResponse(String response) {
            this.response = response;
            return this;
        }

        public Builder setOpaque(String opaque) {
            this.opaque = opaque;
            return this;
        }

        public Builder setQop(String qop) {
            if (MiscUtils.isNonEmpty(qop)) {
                this.qop = qop;
            }
            return this;
        }

        public Builder setNc(String nc) {
            this.nc = nc;
            return this;
        }

        public Builder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder setUsePreemptiveAuth(boolean usePreemptiveAuth) {
            this.usePreemptive = usePreemptiveAuth;
            return this;
        }

        public Builder setUseAbsoluteURI(boolean useAbsoluteURI) {
            this.useAbsoluteURI = useAbsoluteURI;
            return this;
        }

        public Builder setOmitQuery(boolean omitQuery) {
            this.omitQuery = omitQuery;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder setCustomLoginConfig(Map<String, String> customLoginConfig) {
            this.customLoginConfig = customLoginConfig;
            return this;
        }

        public Builder setServicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            return this;
        }

        public Builder setUseCanonicalHostname(boolean useCanonicalHostname) {
            this.useCanonicalHostname = useCanonicalHostname;
            return this;
        }

        public Builder setLoginContextName(String loginContextName) {
            this.loginContextName = loginContextName;
            return this;
        }

        private static String parseRawQop(String rawQop) {
            String[] rawServerSupportedQops = rawQop.split(",");
            String[] serverSupportedQops = new String[rawServerSupportedQops.length];
            for (int i = 0; i < rawServerSupportedQops.length; ++i) {
                serverSupportedQops[i] = rawServerSupportedQops[i].trim();
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!"auth".equals(rawServerSupportedQop)) continue;
                return rawServerSupportedQop;
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!"auth-int".equals(rawServerSupportedQop)) continue;
                return rawServerSupportedQop;
            }
            return null;
        }

        public Builder parseWWWAuthenticateHeader(String headerLine) {
            String rawQop;
            this.setRealmName(Builder.match(headerLine, "realm")).setNonce(Builder.match(headerLine, "nonce")).setOpaque(Builder.match(headerLine, "opaque")).setScheme(MiscUtils.isNonEmpty(this.nonce) ? AuthScheme.DIGEST : AuthScheme.BASIC);
            String algorithm = Builder.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            if ((rawQop = Builder.match(headerLine, "qop")) != null) {
                this.setQop(Builder.parseRawQop(rawQop));
            }
            return this;
        }

        public Builder parseProxyAuthenticateHeader(String headerLine) {
            this.setRealmName(Builder.match(headerLine, "realm")).setNonce(Builder.match(headerLine, "nonce")).setOpaque(Builder.match(headerLine, "opaque")).setScheme(MiscUtils.isNonEmpty(this.nonce) ? AuthScheme.DIGEST : AuthScheme.BASIC);
            String algorithm = Builder.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            this.setQop(Builder.match(headerLine, "qop"));
            return this;
        }

        private void newCnonce(MessageDigest md) {
            byte[] b = new byte[8];
            ThreadLocalRandom.current().nextBytes(b);
            b = md.digest(b);
            this.cnonce = StringUtils.toHexString(b);
        }

        private static String match(String headerLine, String token) {
            if (headerLine == null) {
                return null;
            }
            int match = headerLine.indexOf(token);
            if (match <= 0) {
                return null;
            }
            int trailingComa = headerLine.indexOf(44, match += token.length() + 1);
            String value = headerLine.substring(match, trailingComa > 0 ? trailingComa : headerLine.length());
            value = value.length() > 0 && value.charAt(value.length() - 1) == '\"' ? value.substring(0, value.length() - 1) : value;
            return value.charAt(0) == '\"' ? value.substring(1) : value;
        }

        private static byte[] md5FromRecycledStringBuilder(StringBuilder sb, MessageDigest md) {
            md.update(StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.ISO_8859_1));
            sb.setLength(0);
            return md.digest();
        }

        private byte[] ha1(StringBuilder sb, MessageDigest md) {
            sb.append(this.principal).append(':').append(this.realmName).append(':').append(this.password);
            byte[] core = Builder.md5FromRecycledStringBuilder(sb, md);
            if (this.algorithm == null || "MD5".equals(this.algorithm)) {
                return core;
            }
            if ("MD5-sess".equals(this.algorithm)) {
                StringUtils.appendBase16(sb, core);
                sb.append(':').append(this.nonce).append(':').append(this.cnonce);
                return Builder.md5FromRecycledStringBuilder(sb, md);
            }
            throw new UnsupportedOperationException("Digest algorithm not supported: " + this.algorithm);
        }

        private byte[] ha2(StringBuilder sb, String digestUri, MessageDigest md) {
            sb.append(this.methodName).append(':').append(digestUri);
            if ("auth-int".equals(this.qop)) {
                sb.append(':').append(Realm.EMPTY_ENTITY_MD5);
            } else if (this.qop != null && !"auth".equals(this.qop)) {
                throw new UnsupportedOperationException("Digest qop not supported: " + this.qop);
            }
            return Builder.md5FromRecycledStringBuilder(sb, md);
        }

        private void appendMiddlePart(StringBuilder sb) {
            sb.append(':').append(this.nonce).append(':');
            if ("auth".equals(this.qop) || "auth-int".equals(this.qop)) {
                sb.append(this.nc).append(':').append(this.cnonce).append(':').append(this.qop).append(':');
            }
        }

        private void newResponse(MessageDigest md) {
            if (this.uri != null) {
                String digestUri = AuthenticatorUtils.computeRealmURI(this.uri, this.useAbsoluteURI, this.omitQuery);
                StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
                byte[] ha1 = this.ha1(sb, md);
                byte[] ha2 = this.ha2(sb, digestUri, md);
                StringUtils.appendBase16(sb, ha1);
                this.appendMiddlePart(sb);
                StringUtils.appendBase16(sb, ha2);
                byte[] responseDigest = Builder.md5FromRecycledStringBuilder(sb, md);
                this.response = StringUtils.toHexString(responseDigest);
            }
        }

        public Realm build() {
            if (MiscUtils.isNonEmpty(this.nonce)) {
                MessageDigest md = MessageDigestUtils.pooledMd5MessageDigest();
                this.newCnonce(md);
                this.newResponse(md);
            }
            return new Realm(this.scheme, this.principal, this.password, this.realmName, this.nonce, this.algorithm, this.response, this.opaque, this.qop, this.nc, this.cnonce, this.uri, this.usePreemptive, this.charset, this.ntlmDomain, this.ntlmHost, this.useAbsoluteURI, this.omitQuery, this.servicePrincipalName, this.useCanonicalHostname, this.customLoginConfig, this.loginContextName);
        }
    }

    public static enum AuthScheme {
        BASIC,
        DIGEST,
        NTLM,
        SPNEGO,
        KERBEROS;

    }
}

