/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.filter;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;

public class FilterContext<T> {
    private final FilterContextBuilder<T> builder;

    private FilterContext(FilterContextBuilder<T> builder) {
        this.builder = builder;
    }

    public AsyncHandler<T> getAsyncHandler() {
        return this.builder.asyncHandler;
    }

    public Request getRequest() {
        return this.builder.request;
    }

    public HttpResponseStatus getResponseStatus() {
        return this.builder.responseStatus;
    }

    public HttpHeaders getResponseHeaders() {
        return this.builder.headers;
    }

    public boolean replayRequest() {
        return this.builder.replayRequest;
    }

    public IOException getIOException() {
        return this.builder.ioException;
    }

    public static class FilterContextBuilder<T> {
        private AsyncHandler<T> asyncHandler;
        private Request request;
        private HttpResponseStatus responseStatus;
        private boolean replayRequest;
        private IOException ioException;
        private HttpHeaders headers;

        public FilterContextBuilder() {
        }

        public FilterContextBuilder(FilterContext<T> clone) {
            this.asyncHandler = clone.getAsyncHandler();
            this.request = clone.getRequest();
            this.responseStatus = clone.getResponseStatus();
            this.replayRequest = clone.replayRequest();
            this.ioException = clone.getIOException();
        }

        public AsyncHandler<T> getAsyncHandler() {
            return this.asyncHandler;
        }

        public FilterContextBuilder<T> asyncHandler(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
            return this;
        }

        public Request getRequest() {
            return this.request;
        }

        public FilterContextBuilder<T> request(Request request) {
            this.request = request;
            return this;
        }

        public FilterContextBuilder<T> responseStatus(HttpResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public FilterContextBuilder<T> responseHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public FilterContextBuilder<T> replayRequest(boolean replayRequest) {
            this.replayRequest = replayRequest;
            return this;
        }

        public FilterContextBuilder<T> ioException(IOException ioException) {
            this.ioException = ioException;
            return this;
        }

        public FilterContext<T> build() {
            return new FilterContext(this);
        }
    }
}

