/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;

public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static boolean isUtf8OrUsAscii(Charset charset) {
        return charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byteBuf2StringDefault(Charset charset, ByteBuf ... bufs) {
        if (bufs.length == 1) {
            return bufs[0].toString(charset);
        }
        for (ByteBuf buf : bufs) {
            buf.retain();
        }
        ByteBuf composite = Unpooled.wrappedBuffer((ByteBuf[])bufs);
        try {
            String string = composite.toString(charset);
            return string;
        }
        finally {
            composite.release();
        }
    }

    public static String byteBuf2String(Charset charset, ByteBuf buf) throws CharacterCodingException {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(buf) : buf.toString(charset);
    }

    public static String byteBuf2String(Charset charset, ByteBuf ... bufs) throws CharacterCodingException {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(bufs) : ByteBufUtils.byteBuf2StringDefault(charset, bufs);
    }

    public static byte[] byteBuf2Bytes(ByteBuf buf) {
        byte[] array;
        int readable = buf.readableBytes();
        int readerIndex = buf.readerIndex();
        if (buf.hasArray()) {
            array = buf.array();
            if (buf.arrayOffset() == 0 && readerIndex == 0 && array.length == readable) {
                return array;
            }
        }
        array = new byte[readable];
        buf.getBytes(readerIndex, array);
        return array;
    }
}

