/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.enhance.agent;

import com.avaje.ebean.enhance.agent.ClassMeta;
import com.avaje.ebean.enhance.asm.AnnotationVisitor;
import com.avaje.ebean.enhance.asm.Label;
import com.avaje.ebean.enhance.asm.MethodVisitor;
import com.avaje.ebean.enhance.asm.Opcodes;

public class MethodFieldAdapter
extends MethodVisitor
implements Opcodes {
    private final ClassMeta meta;
    private final String className;
    private final String methodDescription;
    private boolean transientAnnotation;

    public MethodFieldAdapter(MethodVisitor mv, ClassMeta meta, String methodDescription) {
        super(327680, mv);
        this.meta = meta;
        this.className = meta.getClassName();
        this.methodDescription = methodDescription;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Ljavax/persistence/Transient;")) {
            this.transientAnnotation = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.transientAnnotation) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 178 || opcode == 179) {
            if (this.meta.isLog(3)) {
                this.meta.log(" ... info: skip static field " + owner + " " + name + " in " + this.methodDescription);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (this.isNonPersistentField(owner, name)) {
            if (this.meta.isLog(3)) {
                this.meta.log(" ... info: non-persistent field " + owner + " " + name + " in " + this.methodDescription);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (opcode == 180) {
            String methodName = "_ebean_get_" + name;
            String methodDesc = "()" + desc;
            if (this.meta.isLog(4)) {
                this.meta.log("GETFIELD method:" + this.methodDescription + " field:" + name + " > " + methodName + " " + methodDesc);
            }
            super.visitMethodInsn(182, this.className, methodName, methodDesc, false);
        } else if (opcode == 181) {
            String methodName = "_ebean_set_" + name;
            String methodDesc = "(" + desc + ")V";
            if (this.meta.isLog(4)) {
                this.meta.log("PUTFIELD method:" + this.methodDescription + " field:" + name + " > " + methodName + " " + methodDesc);
            }
            super.visitMethodInsn(182, this.className, methodName, methodDesc, false);
        } else {
            this.meta.log("Warning adapting method:" + this.methodDescription + "; unexpected static access to a persistent field?? " + name + " opCode not GETFIELD or PUTFIELD??  opCode:" + opcode + "");
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private boolean isNonPersistentField(String owner, String name) {
        return !this.isSameOwner(owner) || !this.meta.isFieldPersistent(name);
    }

    private boolean isSameOwner(String owner) {
        return this.className.equals(owner);
    }
}

