/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.artifact;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.duplicatefinder.ClasspathElement;
import org.basepom.mojo.duplicatefinder.PluginLog;
import org.basepom.mojo.duplicatefinder.artifact.ArtifactHelper;

public class ArtifactFileResolver {
    private static final PluginLog LOG = new PluginLog(ArtifactFileResolver.class);
    private final Multimap<File, Artifact> localFileArtifactCache;
    private final Map<Artifact, File> localArtifactFileCache;
    private final Map<Artifact, File> repoArtifactCache;
    private final Multimap<File, Artifact> repoFileCache;
    private final ImmutableSet<File> bootClasspath;
    private final boolean preferLocal;

    public ArtifactFileResolver(MavenProject project, ImmutableSet<File> bootClasspath, boolean preferLocal) throws DependencyResolutionRequiredException, IOException {
        Preconditions.checkNotNull((Object)project, (Object)"project is null");
        this.preferLocal = preferLocal;
        ImmutableMultimap.Builder localFileArtifactCacheBuilder = ImmutableMultimap.builder();
        this.repoArtifactCache = new HashMap<Artifact, File>(project.getArtifacts().size());
        this.repoFileCache = MultimapBuilder.hashKeys().hashSetValues().build();
        this.bootClasspath = bootClasspath;
        for (Artifact artifact : project.getArtifacts()) {
            File repoPath = artifact.getFile().getCanonicalFile();
            DefaultArtifact canonicalizedArtifact = ArtifactFileResolver.canonicalizeArtifact(artifact);
            Preconditions.checkState((repoPath != null && repoPath.exists() ? 1 : 0) != 0, (String)"Repository Path '%s' does not exist.", (Object)repoPath);
            File oldFile = this.repoArtifactCache.put((Artifact)canonicalizedArtifact, repoPath);
            Preconditions.checkState((oldFile == null || oldFile.equals(repoPath) ? 1 : 0) != 0, (String)"Already encountered a file for %s: %s", (Object)canonicalizedArtifact, (Object)oldFile);
            this.repoFileCache.put((Object)repoPath, (Object)canonicalizedArtifact);
        }
        for (MavenProject referencedProject : project.getProjectReferences().values()) {
            Set<Artifact> repoArtifacts = ArtifactFileResolver.findRepoArtifacts(referencedProject, this.repoArtifactCache);
            if (repoArtifacts.isEmpty()) {
                LOG.debug("Found project reference to %s but no repo reference, probably used in a plugin dependency.", referencedProject.getArtifact());
            }
            for (Artifact artifact : repoArtifacts) {
                File outputDir = ArtifactHelper.isTestArtifact(artifact) ? ArtifactHelper.getTestOutputDirectory(referencedProject) : ArtifactHelper.getOutputDirectory(referencedProject);
                if (outputDir == null || !outputDir.exists()) continue;
                localFileArtifactCacheBuilder.put((Object)outputDir, (Object)artifact);
            }
        }
        this.localFileArtifactCache = localFileArtifactCacheBuilder.build();
        ImmutableMap.Builder localArtifactFileCacheBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.localFileArtifactCache.entries()) {
            localArtifactFileCacheBuilder.put((Object)((Artifact)entry.getValue()), (Object)((File)entry.getKey()));
        }
        this.localArtifactFileCache = localArtifactFileCacheBuilder.build();
    }

    public ImmutableMultimap<File, Artifact> resolveArtifactsForScopes(Set<String> scopes) throws InvalidVersionSpecificationException, DependencyResolutionRequiredException {
        Preconditions.checkNotNull(scopes, (Object)"scopes is null");
        ImmutableMultimap.Builder inScopeBuilder = ImmutableMultimap.builder();
        for (Artifact artifact : this.listArtifacts()) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !scopes.isEmpty() && !scopes.contains(artifact.getScope())) continue;
            File file = this.resolveFileForArtifact(artifact);
            Preconditions.checkState((file != null ? 1 : 0) != 0, (String)"No file for artifact '%s' found!", (Object)artifact);
            inScopeBuilder.put((Object)file, (Object)artifact);
        }
        return inScopeBuilder.build();
    }

    public ImmutableSortedSet<ClasspathElement> getClasspathElementsForElements(Collection<File> elements) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (File element : elements) {
            this.resolveClasspathElementsForFile(element, (ImmutableSet.Builder<ClasspathElement>)builder);
        }
        return builder.build();
    }

    private void resolveClasspathElementsForFile(File file, ImmutableSet.Builder<ClasspathElement> builder) {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        if (this.preferLocal && this.localFileArtifactCache.containsKey((Object)file)) {
            for (Artifact artifact : this.localFileArtifactCache.get((Object)file)) {
                builder.add((Object)new ClasspathElement.ClasspathArtifact(artifact));
            }
            return;
        }
        if (this.repoFileCache.containsKey((Object)file)) {
            for (Artifact artifact : this.repoFileCache.get((Object)file)) {
                builder.add((Object)new ClasspathElement.ClasspathArtifact(artifact));
            }
            return;
        }
        if (this.bootClasspath.contains((Object)file)) {
            builder.add((Object)new ClasspathElement.ClasspathBootClasspathElement(file));
            return;
        }
        if (this.localFileArtifactCache.containsKey((Object)file)) {
            for (Artifact artifact : this.localFileArtifactCache.get((Object)file)) {
                builder.add((Object)new ClasspathElement.ClasspathArtifact(artifact));
            }
            return;
        }
        builder.add((Object)new ClasspathElement.ClasspathLocalFolder(file));
    }

    private File resolveFileForArtifact(Artifact artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        if (this.preferLocal && this.localArtifactFileCache.containsKey(artifact)) {
            return this.localArtifactFileCache.get(artifact);
        }
        if (this.repoArtifactCache.containsKey(artifact)) {
            return this.repoArtifactCache.get(artifact);
        }
        return this.localArtifactFileCache.get(artifact);
    }

    @VisibleForTesting
    static DefaultArtifact canonicalizeArtifact(Artifact artifact) {
        VersionRange versionRange = artifact.getVersionRange() == null ? VersionRange.createFromVersion((String)artifact.getVersion()) : artifact.getVersionRange();
        String type = (String)MoreObjects.firstNonNull((Object)artifact.getType(), (Object)"jar");
        String classifier = artifact.getClassifier();
        if ("test-jar".equals(type) && (classifier == null || "tests".equals(classifier))) {
            type = "jar";
            classifier = "tests";
        }
        DefaultArtifact canonicalizedArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), versionRange, artifact.getScope(), type, classifier, artifact.getArtifactHandler(), artifact.isOptional());
        return canonicalizedArtifact;
    }

    private Set<Artifact> listArtifacts() {
        return ImmutableSet.builder().addAll(this.localArtifactFileCache.keySet()).addAll(this.repoArtifactCache.keySet()).build();
    }

    private static Set<Artifact> findRepoArtifacts(MavenProject project, Map<Artifact, File> repoArtifactCache) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Artifact artifact : repoArtifactCache.keySet()) {
            if (!Objects.equals(project.getArtifact().getGroupId(), artifact.getGroupId()) || !Objects.equals(project.getArtifact().getArtifactId(), artifact.getArtifactId()) || !Objects.equals(project.getArtifact().getBaseVersion(), artifact.getBaseVersion())) continue;
            builder.add((Object)artifact);
        }
        return builder.build();
    }
}

