/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.duplicatefinder.ClasspathElement;
import org.basepom.mojo.duplicatefinder.ConflictState;
import org.basepom.mojo.duplicatefinder.ConflictType;
import org.basepom.mojo.duplicatefinder.ConflictingDependency;
import org.basepom.mojo.duplicatefinder.ResultCollector;
import org.basepom.mojo.duplicatefinder.XMLWriterUtils;
import org.basepom.mojo.duplicatefinder.artifact.ArtifactFileResolver;
import org.basepom.mojo.duplicatefinder.artifact.ArtifactHelper;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;
import org.basepom.mojo.duplicatefinder.classpath.ClasspathDescriptor;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.staxmate.SMOutputFactory;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.codehaus.staxmate.out.SMOutputElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="check", requiresProject=true, threadSafe=true, defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public final class DuplicateFinderMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicateFinderMojo.class);
    private static final int SAVE_FILE_VERSION = 1;
    private static final HashFunction SHA_256 = Hashing.sha256();
    private static final Set<String> COMPILE_SCOPE = ImmutableSet.of((Object)"compile", (Object)"provided", (Object)"system");
    private static final Set<String> RUNTIME_SCOPE = ImmutableSet.of((Object)"compile", (Object)"runtime");
    private static final Set<String> TEST_SCOPE = ImmutableSet.of();
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="false", property="duplicate-finder.printEqualFiles")
    public boolean printEqualFiles = false;
    @Parameter(defaultValue="false", property="duplicate-finder.failBuildInCaseOfDifferentContentConflict")
    public boolean failBuildInCaseOfDifferentContentConflict = false;
    @Parameter(defaultValue="false", property="duplicate-finder.failBuildInCaseOfEqualContentConflict")
    public boolean failBuildInCaseOfEqualContentConflict = false;
    @Parameter(defaultValue="false", property="duplicate-finder.failBuildInCaseOfConflict")
    public boolean failBuildInCaseOfConflict = false;
    @Parameter(defaultValue="true", property="duplicate-finder.useDefaultResourceIgnoreList")
    public boolean useDefaultResourceIgnoreList = true;
    @Parameter(defaultValue="true", property="duplicate-finder.useDefaultClassIgnoreList")
    public boolean useDefaultClassIgnoreList = true;
    @Parameter
    public String[] ignoredResourcePatterns = new String[0];
    @Parameter
    public String[] ignoredClassPatterns = new String[0];
    @Parameter(alias="exceptions")
    public ConflictingDependency[] conflictingDependencies = new ConflictingDependency[0];
    @Parameter(alias="ignoredDependencies")
    public MavenCoordinates[] ignoredDependencies = new MavenCoordinates[0];
    @Parameter(defaultValue="true", property="duplicate-finder.checkCompileClasspath")
    public boolean checkCompileClasspath = true;
    @Parameter(defaultValue="true", property="duplicate-finder.checkRuntimeClasspath")
    public boolean checkRuntimeClasspath = true;
    @Parameter(defaultValue="true", property="duplicate-finder.checkTestClasspath")
    public boolean checkTestClasspath = true;
    @Parameter(defaultValue="false", property="duplicate-finder.skip")
    public boolean skip = false;
    @Deprecated
    @Parameter(defaultValue="false", property="duplicate-finder.quiet")
    public boolean quiet = false;
    @Parameter(defaultValue="true", property="duplicate-finder.preferLocal")
    public boolean preferLocal = true;
    @Parameter(defaultValue="${project.build.directory}/duplicate-finder-result.xml", property="duplicate-finder.resultFile")
    public File resultFile;
    @Parameter(defaultValue="true", property="duplicate-finder.useResultFile")
    public boolean useResultFile = true;
    @Parameter(defaultValue="2", property="duplicate-finder.resultFileMinClasspathCount")
    public int resultFileMinClasspathCount = 2;
    @Deprecated
    @Parameter(defaultValue="false", property="duplicate-finder.includeBootClasspath")
    public boolean includeBootClasspath = false;
    @Deprecated
    @Parameter(property="duplicate-finder.bootClasspathProperty")
    public String bootClasspathProperty = null;
    @Parameter(defaultValue="false", property="duplicate-finder.includePomProjects")
    public boolean includePomProjects = false;
    private final EnumSet<ConflictState> printState = EnumSet.of(ConflictState.CONFLICT_CONTENT_DIFFERENT);
    private final EnumSet<ConflictState> failState = EnumSet.noneOf(ConflictState.class);

    public void setIgnoredDependencies(Dependency[] dependencies) throws InvalidVersionSpecificationException {
        Preconditions.checkArgument((dependencies != null ? 1 : 0) != 0);
        this.ignoredDependencies = new MavenCoordinates[dependencies.length];
        for (int idx = 0; idx < dependencies.length; ++idx) {
            this.ignoredDependencies[idx] = new MavenCoordinates(dependencies[idx]);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            LOG.info("Skipping duplicate-finder execution!");
        } else if (!this.includePomProjects && "pom".equals(this.project.getArtifact().getType())) {
            LOG.info("Ignoring POM project!");
        } else {
            if (this.printEqualFiles) {
                this.printState.add(ConflictState.CONFLICT_CONTENT_EQUAL);
            }
            if (this.failBuildInCaseOfConflict || this.failBuildInCaseOfEqualContentConflict) {
                this.printState.add(ConflictState.CONFLICT_CONTENT_EQUAL);
                this.failState.add(ConflictState.CONFLICT_CONTENT_EQUAL);
                this.failState.add(ConflictState.CONFLICT_CONTENT_DIFFERENT);
            }
            if (this.failBuildInCaseOfDifferentContentConflict) {
                this.failState.add(ConflictState.CONFLICT_CONTENT_DIFFERENT);
            }
            if (this.includeBootClasspath) {
                LOG.warn("<includeBootClasspath> is no longer supported and will be ignored!");
            }
            if (this.bootClasspathProperty != null) {
                LOG.warn("<bootClasspathProperty> is no longer supported and will be ignored!");
            }
            if (this.quiet) {
                LOG.warn("<quiet> is no longer supported and will be ignored!");
            }
            try {
                ClasspathDescriptor classpathDescriptor;
                MavenCoordinates projectCoordinates = new MavenCoordinates(this.project.getArtifact());
                for (ConflictingDependency conflictingDependency : this.conflictingDependencies) {
                    conflictingDependency.addProjectMavenCoordinates(projectCoordinates);
                }
                ArtifactFileResolver artifactFileResolver = new ArtifactFileResolver(this.project, this.preferLocal);
                ImmutableMap.Builder classpathResultBuilder = ImmutableMap.builder();
                if (this.checkCompileClasspath) {
                    LOG.info("Checking compile classpath");
                    ResultCollector resultCollector = new ResultCollector(this.printState, this.failState);
                    classpathDescriptor = this.checkClasspath(resultCollector, artifactFileResolver, COMPILE_SCOPE, ArtifactHelper.getOutputDirectory(this.project));
                    classpathResultBuilder.put((Object)"compile", new AbstractMap.SimpleImmutableEntry<ResultCollector, ClasspathDescriptor>(resultCollector, classpathDescriptor));
                }
                if (this.checkRuntimeClasspath) {
                    LOG.info("Checking runtime classpath");
                    ResultCollector resultCollector = new ResultCollector(this.printState, this.failState);
                    classpathDescriptor = this.checkClasspath(resultCollector, artifactFileResolver, RUNTIME_SCOPE, ArtifactHelper.getOutputDirectory(this.project));
                    classpathResultBuilder.put((Object)"runtime", new AbstractMap.SimpleImmutableEntry<ResultCollector, ClasspathDescriptor>(resultCollector, classpathDescriptor));
                }
                if (this.checkTestClasspath) {
                    LOG.info("Checking test classpath");
                    ResultCollector resultCollector = new ResultCollector(this.printState, this.failState);
                    classpathDescriptor = this.checkClasspath(resultCollector, artifactFileResolver, TEST_SCOPE, ArtifactHelper.getOutputDirectory(this.project), ArtifactHelper.getTestOutputDirectory(this.project));
                    classpathResultBuilder.put((Object)"test", new AbstractMap.SimpleImmutableEntry<ResultCollector, ClasspathDescriptor>(resultCollector, classpathDescriptor));
                }
                ImmutableMap classpathResults = classpathResultBuilder.build();
                if (this.useResultFile) {
                    Preconditions.checkState((this.resultFile != null ? 1 : 0) != 0, (Object)"resultFile must be set if useResultFile is true");
                    this.writeResultFile(this.resultFile, (ImmutableMap<String, Map.Entry<ResultCollector, ClasspathDescriptor>>)classpathResults);
                }
                boolean failed = false;
                for (Map.Entry classpathEntry : classpathResults.entrySet()) {
                    String classpathName = (String)classpathEntry.getKey();
                    ResultCollector resultCollector = (ResultCollector)((Map.Entry)classpathEntry.getValue()).getKey();
                    for (ConflictState state : this.printState) {
                        for (ConflictType type : ConflictType.values()) {
                            if (!resultCollector.hasConflictsFor(type, state)) continue;
                            Map<String, Collection<ResultCollector.ConflictResult>> results = resultCollector.getResults(type, state);
                            for (Map.Entry<String, Collection<ResultCollector.ConflictResult>> entry : results.entrySet()) {
                                String artifactNames = entry.getKey();
                                Collection<ResultCollector.ConflictResult> conflictResults = entry.getValue();
                                LOG.warn(String.format("Found duplicate %s %s in [%s]:", state.getHint(), type.getType(), artifactNames));
                                for (ResultCollector.ConflictResult conflictResult : conflictResults) {
                                    LOG.warn(String.format("  %s", conflictResult.getName()));
                                }
                            }
                        }
                    }
                    failed |= resultCollector.isFailed();
                    if (!resultCollector.isFailed()) continue;
                    LOG.warn(String.format("Found duplicate classes/resources in %s classpath.", classpathName));
                }
                if (failed) {
                    throw new MojoExecutionException("Found duplicate classes/resources!");
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoFailureException("Could not resolve dependencies", (Throwable)e);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoFailureException("Invalid version specified", (Throwable)e);
            }
            catch (OverConstrainedVersionException e) {
                throw new MojoFailureException("Version too constrained", (Throwable)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("While loading artifacts", (Exception)e);
            }
        }
    }

    private ImmutableSet<String> getIgnoredResourcePatterns() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object[])this.ignoredResourcePatterns);
        return builder.build();
    }

    private ImmutableSet<String> getIgnoredClassPatterns() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object[])this.ignoredClassPatterns);
        return builder.build();
    }

    private ClasspathDescriptor checkClasspath(ResultCollector resultCollector, ArtifactFileResolver artifactFileResolver, Set<String> scopes, File ... projectFolders) throws MojoExecutionException, InvalidVersionSpecificationException, OverConstrainedVersionException, DependencyResolutionRequiredException {
        ImmutableMultimap<File, Artifact> fileToArtifactMap = artifactFileResolver.resolveArtifactsForScopes(scopes);
        ClasspathDescriptor classpathDescriptor = ClasspathDescriptor.createClasspathDescriptor(this.project, fileToArtifactMap, this.getIgnoredResourcePatterns(), this.getIgnoredClassPatterns(), Arrays.asList(this.ignoredDependencies), this.useDefaultResourceIgnoreList, this.useDefaultClassIgnoreList, projectFolders);
        this.checkForDuplicates(ConflictType.CLASS, resultCollector, classpathDescriptor, artifactFileResolver);
        this.checkForDuplicates(ConflictType.RESOURCE, resultCollector, classpathDescriptor, artifactFileResolver);
        return classpathDescriptor;
    }

    private void checkForDuplicates(ConflictType type, ResultCollector resultCollector, ClasspathDescriptor classpathDescriptor, ArtifactFileResolver artifactFileResolver) throws OverConstrainedVersionException {
        ImmutableMap filteredMap = ImmutableMap.copyOf((Map)Maps.filterEntries(classpathDescriptor.getClasspathElementLocations(type), entry -> {
            Preconditions.checkNotNull((Object)entry, (Object)"entry is null");
            Preconditions.checkState((entry.getValue() != null ? 1 : 0) != 0, (String)"Entry '%s' is invalid", (Object)entry);
            return ((Collection)entry.getValue()).size() > 1;
        }));
        for (Map.Entry entry2 : filteredMap.entrySet()) {
            String name = (String)entry2.getKey();
            Collection elements = (Collection)entry2.getValue();
            ImmutableSortedSet<ClasspathElement> conflictingClasspathElements = artifactFileResolver.getClasspathElementsForElements(elements);
            ImmutableSet.Builder artifactBuilder = ImmutableSet.builder();
            for (ClasspathElement conflictingClasspathElement : conflictingClasspathElements) {
                if (conflictingClasspathElement.hasArtifact()) {
                    artifactBuilder.add((Object)conflictingClasspathElement.getArtifact());
                    continue;
                }
                if (!conflictingClasspathElement.isLocalFolder()) continue;
                artifactBuilder.add((Object)this.project.getArtifact());
            }
            boolean excepted = this.isExcepted(type, name, (Set<Artifact>)artifactBuilder.build());
            ConflictState conflictState = DuplicateFinderMojo.determineConflictState(type, name, elements);
            resultCollector.addConflict(type, name, (SortedSet<ClasspathElement>)conflictingClasspathElements, excepted, conflictState);
        }
    }

    private static ConflictState determineConflictState(ConflictType type, String name, Iterable<File> elements) {
        File firstFile = null;
        String firstSHA256 = null;
        String resourcePath = type == ConflictType.CLASS ? name.replace('.', '/') + ".class" : name;
        for (File element : elements) {
            try {
                String newSHA256 = DuplicateFinderMojo.getSHA256HexOfElement(element, resourcePath);
                if (firstSHA256 == null) {
                    firstSHA256 = newSHA256;
                    firstFile = element;
                    continue;
                }
                if (newSHA256.equals(firstSHA256)) continue;
                LOG.debug(String.format("Found different SHA256 hashes for elements %s in file %s and %s", resourcePath, firstFile, element));
                return ConflictState.CONFLICT_CONTENT_DIFFERENT;
            }
            catch (IOException ex) {
                LOG.warn(String.format("Could not read content from file %s!", element), (Throwable)ex);
            }
        }
        return ConflictState.CONFLICT_CONTENT_EQUAL;
    }

    private static String getSHA256HexOfElement(File file, String resourcePath) throws IOException {
        try (Closer closer = Closer.create();){
            InputStream in;
            if (file.isDirectory()) {
                File resourceFile = new File(file, resourcePath);
                in = (InputStream)closer.register((Closeable)new BufferedInputStream(new FileInputStream(resourceFile)));
            } else {
                ZipFile zip = new ZipFile(file);
                closer.register(zip::close);
                ZipEntry zipEntry = zip.getEntry(resourcePath);
                if (zipEntry == null) {
                    throw new IOException(String.format("Could not find %s in archive %s", resourcePath, file));
                }
                in = zip.getInputStream(zipEntry);
            }
            String string = SHA_256.newHasher().putBytes(ByteStreams.toByteArray((InputStream)in)).hash().toString();
            return string;
        }
    }

    private boolean isExcepted(ConflictType type, String name, Set<Artifact> artifacts) throws OverConstrainedVersionException {
        ImmutableSet.Builder conflictBuilder = ImmutableSet.builder();
        Preconditions.checkState((this.conflictingDependencies != null ? 1 : 0) != 0, (Object)"conflictingDependencies is null");
        for (ConflictingDependency conflictingDependency : this.conflictingDependencies) {
            if (!conflictingDependency.isForArtifacts(artifacts)) continue;
            conflictBuilder.add((Object)conflictingDependency);
        }
        for (ConflictingDependency conflictingDependency : conflictBuilder.build()) {
            if (type == ConflictType.CLASS && conflictingDependency.containsClass(name)) {
                return true;
            }
            if (type != ConflictType.RESOURCE || !conflictingDependency.containsResource(name)) continue;
            return true;
        }
        return false;
    }

    private void writeResultFile(File resultFile, ImmutableMap<String, Map.Entry<ResultCollector, ClasspathDescriptor>> results) throws MojoExecutionException, InvalidVersionSpecificationException, OverConstrainedVersionException {
        File parent = resultFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new MojoExecutionException("Could not create parent folders for " + parent.getAbsolutePath());
        }
        if (!parent.isDirectory() || !parent.canWrite()) {
            throw new MojoExecutionException("Can not create result file in " + parent.getAbsolutePath());
        }
        try {
            SMOutputFactory factory = new SMOutputFactory(XMLOutputFactory2.newFactory());
            SMOutputDocument resultDocument = factory.createOutputDocument(resultFile);
            resultDocument.setIndentation("\n" + Strings.repeat((String)" ", (int)64), 1, 4);
            SMOutputElement rootElement = resultDocument.addElement("duplicate-finder-result");
            XMLWriterUtils.addAttribute(rootElement, "version", 1);
            XMLWriterUtils.addProjectInformation(rootElement, this.project);
            this.addConfiguration(rootElement);
            SMOutputElement resultsElement = rootElement.addElement("results");
            for (Map.Entry entry : results.entrySet()) {
                SMOutputElement resultElement = resultsElement.addElement("result");
                XMLWriterUtils.addAttribute(resultElement, "name", entry.getKey());
                XMLWriterUtils.addResultCollector(resultElement, (ResultCollector)((Map.Entry)entry.getValue()).getKey());
                XMLWriterUtils.addClasspathDescriptor(resultElement, this.resultFileMinClasspathCount, (ClasspathDescriptor)((Map.Entry)entry.getValue()).getValue());
            }
            resultDocument.closeRootAndWriter();
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("While writing result file", (Exception)e);
        }
    }

    private void addConfiguration(SMOutputElement rootElement) throws XMLStreamException {
        SMOutputElement prefs = XMLWriterUtils.addElement(rootElement, "configuration", null);
        XMLWriterUtils.addAttribute(prefs, "skip", this.skip);
        XMLWriterUtils.addAttribute(prefs, "checkCompileClasspath", this.checkCompileClasspath);
        XMLWriterUtils.addAttribute(prefs, "checkRuntimeClasspath", this.checkRuntimeClasspath);
        XMLWriterUtils.addAttribute(prefs, "checkTestClasspath", this.checkTestClasspath);
        XMLWriterUtils.addAttribute(prefs, "failBuildInCaseOfDifferentContentConflict", this.failBuildInCaseOfDifferentContentConflict);
        XMLWriterUtils.addAttribute(prefs, "failBuildInCaseOfEqualContentConflict", this.failBuildInCaseOfEqualContentConflict);
        XMLWriterUtils.addAttribute(prefs, "failBuildInCaseOfConflict", this.failBuildInCaseOfConflict);
        XMLWriterUtils.addAttribute(prefs, "printEqualFiles", this.printEqualFiles);
        XMLWriterUtils.addAttribute(prefs, "preferLocal", this.preferLocal);
        XMLWriterUtils.addAttribute(prefs, "includePomProjects", this.includePomProjects);
        XMLWriterUtils.addAttribute(prefs, "useDefaultResourceIgnoreList", this.useDefaultResourceIgnoreList);
        XMLWriterUtils.addAttribute(prefs, "useDefaultClassIgnoreList", this.useDefaultClassIgnoreList);
        XMLWriterUtils.addAttribute(prefs, "useResultFile", this.useResultFile);
        XMLWriterUtils.addAttribute(prefs, "resultFileMinClasspathCount", this.resultFileMinClasspathCount);
        XMLWriterUtils.addAttribute(prefs, "resultFile", this.resultFile.getAbsolutePath());
        SMOutputElement ignoredResourcesElement = prefs.addElement("ignoredResourcePatterns");
        for (String ignoredResource : this.getIgnoredResourcePatterns()) {
            XMLWriterUtils.addElement(ignoredResourcesElement, "ignoredResourcePattern", ignoredResource);
        }
        SMOutputElement ignoredClassElement = prefs.addElement("ignoredClassPatterns");
        for (ConflictingDependency[] ignoredClass : this.getIgnoredClassPatterns()) {
            XMLWriterUtils.addElement(ignoredClassElement, "ignoredClassPattern", ignoredClass);
        }
        SMOutputElement conflictingDependenciesElement = prefs.addElement("conflictingDependencies");
        for (ConflictingDependency conflictingDependency : this.conflictingDependencies) {
            XMLWriterUtils.addConflictingDependency(conflictingDependenciesElement, "conflictingDependency", conflictingDependency);
        }
        SMOutputElement ignoredDependenciesElement = prefs.addElement("ignoredDependencies");
        for (MavenCoordinates ignoredDependency : this.ignoredDependencies) {
            XMLWriterUtils.addMavenCoordinate(ignoredDependenciesElement, "dependency", ignoredDependency);
        }
    }
}

