/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ClasspathCacheElement {
    private final File element;
    private final ImmutableSet<String> classes;
    private final ImmutableSet<String> resources;

    public static Builder builder(File element) {
        return new Builder(element);
    }

    private ClasspathCacheElement(File element, ImmutableSet<String> classes, ImmutableSet<String> resources) {
        this.element = element;
        this.classes = classes;
        this.resources = resources;
    }

    void putClasses(Multimap<String, File> classMap, Predicate<String> excludePredicate) {
        for (String className : this.classes.stream().filter(excludePredicate.negate()).collect(Collectors.toList())) {
            classMap.put((Object)className, (Object)this.element);
        }
    }

    void putResources(Multimap<String, File> resourceMap, Predicate<String> excludePredicate) {
        for (String resource : this.resources.stream().filter(excludePredicate.negate()).collect(Collectors.toList())) {
            resourceMap.put((Object)resource, (Object)this.element);
        }
    }

    static class Builder {
        private final File element;
        private final ImmutableSet.Builder<String> classBuilder = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> resourcesBuilder = ImmutableSet.builder();

        private Builder(File element) {
            this.element = element;
        }

        void addClass(String className) {
            this.classBuilder.add((Object)className);
        }

        void addResource(String resource) {
            this.resourcesBuilder.add((Object)resource);
        }

        ClasspathCacheElement build() {
            return new ClasspathCacheElement(this.element, (ImmutableSet<String>)this.classBuilder.build(), (ImmutableSet<String>)this.resourcesBuilder.build());
        }
    }
}

