/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.consul;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.orbitz.consul.model.agent.Registration;
import java.util.Map;
import org.bitsofinfo.hazelcast.discovery.consul.HealthCheckBuilder;

public class TcpHealthCheckBuilder
implements HealthCheckBuilder {
    private static final String TCP_TEMPLATE_MYPORT = "#MYPORT";
    private static final String TCP_TEMPLATE_MYIP = "#MYIP";
    public static final String CONFIG_PROP_HEALTH_CHECK_TCP = "healthCheckTcp";
    public static final String CONFIG_PROP_HEALTH_CHECK_TCP_INTERVAL_SECONDS = "healthCheckTcpIntervalSeconds";
    private static final ILogger logger = Logger.getLogger(TcpHealthCheckBuilder.class);

    @Override
    public Registration.RegCheck buildRegistrationCheck(Map<String, Object> registratorConfig, Address localAddress) {
        Registration.RegCheck regCheck = null;
        try {
            String healthCheckTcp = (String)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_TCP);
            if (healthCheckTcp != null && !healthCheckTcp.trim().isEmpty()) {
                healthCheckTcp = healthCheckTcp.replaceAll(TCP_TEMPLATE_MYIP, localAddress.getInetAddress().getHostAddress()).replaceAll(TCP_TEMPLATE_MYPORT, String.valueOf(localAddress.getPort()));
                Long healthCheckTcpIntervalSeconds = (long)((Integer)registratorConfig.get(CONFIG_PROP_HEALTH_CHECK_TCP_INTERVAL_SECONDS));
                regCheck = Registration.RegCheck.tcp((String)healthCheckTcp, (long)healthCheckTcpIntervalSeconds);
            }
        }
        catch (Exception e) {
            logger.severe("Unexpected error occured trying to build TCP health check : " + e.getMessage(), (Throwable)e);
        }
        return regCheck;
    }
}

