/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.spotify.docker.client.messages.Network;
import com.spotify.docker.client.messages.swarm.NetworkAttachment;
import com.spotify.docker.client.messages.swarm.Service;
import com.spotify.docker.client.messages.swarm.Task;

public class DiscoveredContainer {
    private Network network;
    private Service service;
    private Task task;
    private NetworkAttachment relevantNetworkAttachment;

    public DiscoveredContainer(Network network, Service service, Task task, NetworkAttachment relevantNetworkAttachment) {
        this.network = network;
        this.service = service;
        this.task = task;
        this.relevantNetworkAttachment = relevantNetworkAttachment;
    }

    public String getIp() {
        return ((String)this.relevantNetworkAttachment.addresses().iterator().next()).split("/")[0];
    }

    public String getNetworkName() {
        return this.network.name();
    }

    public String getNetworkId() {
        return this.network.id();
    }

    public String getServiceName() {
        return this.service.spec().name();
    }

    public String getServiceId() {
        return this.service.id();
    }

    public String getContainerId() {
        return this.task.status().containerStatus().containerId();
    }

    public String getContainerImage() {
        return this.task.spec().containerSpec().image();
    }

    public int hashCode() {
        return this.getIp().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DiscoveredContainer) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.getIp() + " : " + this.getContainerId();
    }
}

