/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.MemberAddressProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Properties;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.SwarmDiscoveryUtil;

public class SwarmMemberAddressProvider
implements MemberAddressProvider {
    public static final String PROP_SWARM_MGR_URI = "swarmMgrUri";
    public static final String PROP_SKIP_VERIFY_SSL = "skipVerifySsl";
    public static final String PROP_LOG_ALL_SERVICE_NAMES_ON_FAILED_DISCOVERY = "logAllServiceNamesOnFailedDiscovery";
    public static final String PROP_STRICT_DOCKER_SERVICE_NAME_COMPARISON = "strictDockerServiceNameComparison";
    private static final String PROP_DOCKER_NETWORK_NAMES = "dockerNetworkNames";
    private static final String PROP_DOCKER_SERVICE_LABELS = "dockerServiceLabels";
    private static final String PROP_DOCKER_SERVICE_NAMES = "dockerServiceNames";
    private static final String PROP_HAZELCAST_PEER_PORT = "hazelcastPeerPort";
    private SwarmDiscoveryUtil swarmDiscoveryUtil = null;
    private ILogger logger = Logger.getLogger(SwarmMemberAddressProvider.class);

    public SwarmMemberAddressProvider() {
        String dockerNetworkNames = System.getProperty(PROP_DOCKER_NETWORK_NAMES);
        String dockerServiceLabels = System.getProperty(PROP_DOCKER_SERVICE_LABELS);
        String dockerServiceNames = System.getProperty(PROP_DOCKER_SERVICE_NAMES);
        Integer hazelcastPeerPort = Integer.valueOf(System.getProperty(PROP_HAZELCAST_PEER_PORT));
        String swarmMgrUri = System.getProperty(PROP_SWARM_MGR_URI);
        if (swarmMgrUri == null || swarmMgrUri.trim().isEmpty()) {
            swarmMgrUri = System.getenv("DOCKER_HOST");
        }
        Boolean skipVerifySsl = false;
        if (System.getProperty(PROP_SKIP_VERIFY_SSL) != null) {
            skipVerifySsl = Boolean.valueOf(System.getProperty(PROP_SKIP_VERIFY_SSL));
        }
        Boolean logAllServiceNamesOnFailedDiscovery = false;
        if (System.getProperty(PROP_LOG_ALL_SERVICE_NAMES_ON_FAILED_DISCOVERY) != null) {
            logAllServiceNamesOnFailedDiscovery = Boolean.valueOf(System.getProperty(PROP_LOG_ALL_SERVICE_NAMES_ON_FAILED_DISCOVERY));
        }
        Boolean strictDockerServiceNameComparison = false;
        if (System.getProperty(PROP_STRICT_DOCKER_SERVICE_NAME_COMPARISON) != null) {
            strictDockerServiceNameComparison = Boolean.valueOf(System.getProperty(PROP_STRICT_DOCKER_SERVICE_NAME_COMPARISON));
        }
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
    }

    public SwarmMemberAddressProvider(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort, Boolean logAllServiceNamesOnFailedDiscovery, Boolean strictDockerServiceNameComparison) {
        String swarmMgrUri = System.getenv("DOCKER_HOST");
        Boolean skipVerifySsl = false;
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
    }

    public SwarmMemberAddressProvider(Properties properties) {
        Object rawStrictDockerServiceNameComparison;
        Object rawLogAllServiceNamesOnFailedDiscovery;
        Object rawSkipVerifySsl;
        String swarmMgrUri;
        Object rawHazelcastPeerPort;
        String dockerServiceNames;
        String dockerServiceLabels;
        String dockerNetworkNames = (String)properties.get(PROP_DOCKER_NETWORK_NAMES);
        if (dockerNetworkNames == null || dockerNetworkNames.trim().isEmpty()) {
            dockerNetworkNames = System.getProperty(PROP_DOCKER_NETWORK_NAMES);
        }
        if ((dockerServiceLabels = (String)properties.get(PROP_DOCKER_SERVICE_LABELS)) == null || dockerServiceLabels.trim().isEmpty()) {
            dockerServiceLabels = System.getProperty(PROP_DOCKER_SERVICE_LABELS);
        }
        if ((dockerServiceNames = (String)properties.get(PROP_DOCKER_SERVICE_NAMES)) == null || dockerServiceNames.trim().isEmpty()) {
            dockerServiceNames = System.getProperty(PROP_DOCKER_SERVICE_NAMES);
        }
        if ((rawHazelcastPeerPort = properties.get(PROP_HAZELCAST_PEER_PORT)) == null || rawHazelcastPeerPort.toString().trim().isEmpty()) {
            rawHazelcastPeerPort = System.getProperty(PROP_HAZELCAST_PEER_PORT);
        }
        Integer hazelcastPeerPort = 5701;
        if (rawHazelcastPeerPort instanceof String) {
            try {
                hazelcastPeerPort = Integer.valueOf(rawHazelcastPeerPort.toString());
            }
            catch (Throwable throwable) {}
        } else if (rawHazelcastPeerPort instanceof Integer) {
            hazelcastPeerPort = (Integer)rawHazelcastPeerPort;
        }
        if ((swarmMgrUri = (String)properties.get(PROP_SWARM_MGR_URI)) == null || swarmMgrUri.trim().isEmpty()) {
            swarmMgrUri = System.getProperty(PROP_SWARM_MGR_URI);
        }
        if (swarmMgrUri == null || swarmMgrUri.trim().isEmpty()) {
            swarmMgrUri = System.getenv("DOCKER_HOST");
        }
        if ((rawSkipVerifySsl = properties.get(PROP_SKIP_VERIFY_SSL)) == null || rawSkipVerifySsl.toString().trim().isEmpty()) {
            rawSkipVerifySsl = System.getProperty(PROP_SKIP_VERIFY_SSL);
        }
        Boolean skipVerifySsl = false;
        if (rawSkipVerifySsl != null) {
            skipVerifySsl = Boolean.valueOf(rawSkipVerifySsl.toString());
        }
        if ((rawLogAllServiceNamesOnFailedDiscovery = properties.get(PROP_LOG_ALL_SERVICE_NAMES_ON_FAILED_DISCOVERY)) == null || rawLogAllServiceNamesOnFailedDiscovery.toString().trim().isEmpty()) {
            rawLogAllServiceNamesOnFailedDiscovery = System.getProperty(PROP_LOG_ALL_SERVICE_NAMES_ON_FAILED_DISCOVERY);
        }
        Boolean logAllServiceNamesOnFailedDiscovery = false;
        if (rawLogAllServiceNamesOnFailedDiscovery != null) {
            logAllServiceNamesOnFailedDiscovery = Boolean.valueOf(rawLogAllServiceNamesOnFailedDiscovery.toString());
        }
        if ((rawStrictDockerServiceNameComparison = properties.get(PROP_STRICT_DOCKER_SERVICE_NAME_COMPARISON)) == null || rawStrictDockerServiceNameComparison.toString().trim().isEmpty()) {
            rawStrictDockerServiceNameComparison = System.getProperty(PROP_STRICT_DOCKER_SERVICE_NAME_COMPARISON);
        }
        Boolean strictDockerServiceNameComparison = false;
        if (rawStrictDockerServiceNameComparison != null) {
            strictDockerServiceNameComparison = Boolean.valueOf(rawStrictDockerServiceNameComparison.toString());
        }
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
    }

    public SwarmMemberAddressProvider(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Object hazelcastPeerPort, Object logAllServiceNamesOnFailedDiscovery, Object strictDockerServiceNameComparison) {
        String swarmMgrUri = System.getenv("DOCKER_HOST");
        Boolean skipVerifySsl = false;
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, swarmMgrUri, skipVerifySsl, hazelcastPeerPort, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
    }

    private void initialize(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort, String swarmMgrUri, Boolean skipVerifySsl, Boolean logAllServiceNamesOnFailedDiscovery, Boolean strictDockerServiceNameComparison) {
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, swarmMgrUri, skipVerifySsl, hazelcastPeerPort, (Object)logAllServiceNamesOnFailedDiscovery, (Object)strictDockerServiceNameComparison);
    }

    private void initialize(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, String swarmMgrUri, Boolean skipVerifySsl, Object rawHazelcastPeerPort, Object rawLogAllServiceNamesOnFailedDiscovery, Object rawStrictDockerServiceNameComparison) {
        this.logger.info("SwarmMemberAddressProvider.initialize() passed properties: dockerNetworkNames:" + dockerNetworkNames + " dockerServiceLabels:" + dockerServiceLabels + " dockerServiceNames:" + dockerServiceNames + " swarmMgrUri:" + swarmMgrUri + " skipVerifySsl:" + skipVerifySsl + " hazelcastPeerPort:" + rawHazelcastPeerPort + " logAllServiceNamesOnFailedDiscovery:" + rawLogAllServiceNamesOnFailedDiscovery + " strictDockerServiceNameComparison:" + rawStrictDockerServiceNameComparison);
        Boolean logAllServiceNamesOnFailedDiscovery = false;
        if (rawLogAllServiceNamesOnFailedDiscovery != null) {
            if (rawLogAllServiceNamesOnFailedDiscovery instanceof String) {
                try {
                    logAllServiceNamesOnFailedDiscovery = Boolean.valueOf(((String)rawLogAllServiceNamesOnFailedDiscovery).trim());
                }
                catch (Throwable throwable) {}
            } else if (rawLogAllServiceNamesOnFailedDiscovery instanceof Boolean) {
                logAllServiceNamesOnFailedDiscovery = (Boolean)rawLogAllServiceNamesOnFailedDiscovery;
            }
        }
        Boolean strictDockerServiceNameComparison = false;
        if (rawStrictDockerServiceNameComparison != null) {
            if (rawStrictDockerServiceNameComparison instanceof String) {
                try {
                    strictDockerServiceNameComparison = Boolean.valueOf(((String)rawStrictDockerServiceNameComparison).trim());
                }
                catch (Throwable throwable) {}
            } else if (rawStrictDockerServiceNameComparison instanceof Boolean) {
                strictDockerServiceNameComparison = (Boolean)rawStrictDockerServiceNameComparison;
            }
        }
        Integer hazelcastPeerPort = null;
        if (rawHazelcastPeerPort != null) {
            if (rawHazelcastPeerPort instanceof String) {
                try {
                    hazelcastPeerPort = Integer.valueOf(rawHazelcastPeerPort.toString());
                }
                catch (Throwable throwable) {}
            } else if (rawHazelcastPeerPort instanceof Integer) {
                hazelcastPeerPort = (Integer)rawHazelcastPeerPort;
            }
        }
        int port = hazelcastPeerPort != null ? hazelcastPeerPort : 5701;
        try {
            URI swarmMgr = null;
            swarmMgr = swarmMgrUri == null || swarmMgrUri.trim().isEmpty() ? new URI(System.getenv("DOCKER_HOST")) : new URI(swarmMgrUri);
            this.swarmDiscoveryUtil = new SwarmDiscoveryUtil(this.getClass().getSimpleName(), dockerNetworkNames, dockerServiceLabels, dockerServiceNames, port, false, swarmMgr, skipVerifySsl, logAllServiceNamesOnFailedDiscovery, strictDockerServiceNameComparison);
        }
        catch (Exception e) {
            throw new RuntimeException("SwarmAddressPicker: Error constructing SwarmDiscoveryUtil: " + e.getMessage(), e);
        }
    }

    public InetSocketAddress getBindAddress() {
        Address addr = this.swarmDiscoveryUtil.getMyAddress();
        if (addr == null) {
            this.logger.severe("SwarmMemberAddressProvider.getBindAddress(): swarmDiscoveryUtil.getMyAddress() returned null Hazelcast " + Address.class.getName() + ", I am returning null.");
            return null;
        }
        return new InetSocketAddress(addr.getHost(), addr.getPort());
    }

    public InetSocketAddress getPublicAddress() {
        Address addr = this.swarmDiscoveryUtil.getMyAddress();
        if (addr == null) {
            this.logger.severe("SwarmMemberAddressProvider.getPublicAddress(): swarmDiscoveryUtil.getMyAddress() returned null Hazelcast " + Address.class.getName() + ", I am returning null.");
            return null;
        }
        return new InetSocketAddress(addr.getHost(), addr.getPort());
    }
}

