/*
 * Decompiled with CFR 0.152.
 */
package org.blocks4j.feature.toggle.factory;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.blocks4j.feature.toggle.FeatureToggleConfiguration;
import org.blocks4j.feature.toggle.exception.FeatureToggleFactoryException;
import org.blocks4j.feature.toggle.proxy.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureToggleFactory {
    private static Collection<Feature> toggleList = Collections.synchronizedCollection(new HashSet());
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureToggleFactory.class);
    private FeatureToggleConfiguration config;

    private FeatureToggleFactory(FeatureToggleConfiguration config) {
        this.config = config;
    }

    public static Collection<Feature> getToggleList() {
        return Collections.unmodifiableCollection(toggleList);
    }

    private <T> T createFeatureProxy(String featureName, Class<? super T> commonInterface, T featureOn, T featureOff) {
        this.validateParams(featureName, commonInterface, featureOn, featureOff);
        Feature<T> feature = new Feature<T>();
        feature.setConfig(this.config);
        feature.setCommonsInterface(commonInterface);
        feature.setOn(featureOn);
        feature.setOff(featureOff);
        feature.setName(featureName);
        feature.init();
        Object proxy = Proxy.newProxyInstance(commonInterface.getClassLoader(), new Class[]{commonInterface}, feature);
        LOGGER.info(String.format("Feature [%s] initialized , Object for ON is [%s] and Object for OFF is [%s]", featureName, featureOn.getClass().getSimpleName(), featureOff.getClass().getSimpleName()));
        toggleList.add(feature);
        return (T)proxy;
    }

    private void validateParams(String featureName, Class<?> commonInterface, Object featureOn, Object featureOff) {
        if (!this.isFeatureNameValid(featureName)) {
            throw new FeatureToggleFactoryException("The featureName mustn't be null.");
        }
        if (!this.isCommonInterfaceValid(commonInterface)) {
            throw new FeatureToggleFactoryException("The commonInterface must be a inteface.");
        }
        if (this.isNotObjectValid(commonInterface, featureOn)) {
            throw new FeatureToggleFactoryException(String.format("The featureOn have to implement [%s] ", commonInterface.getName()));
        }
        if (this.isNotObjectValid(commonInterface, featureOff)) {
            throw new FeatureToggleFactoryException(String.format("The featureOff have to implement [%s] ", commonInterface.getName()));
        }
    }

    private boolean isFeatureNameValid(String featureName) {
        return !StringUtils.isEmpty((CharSequence)featureName);
    }

    private boolean isObjectValid(Class<?> commonInterface, Object feature) {
        return commonInterface != null && feature != null && commonInterface.isAssignableFrom(feature.getClass());
    }

    private boolean isNotObjectValid(Class<?> commonInterface, Object feature) {
        return !this.isObjectValid(commonInterface, feature);
    }

    private boolean isCommonInterfaceValid(Class<?> commonInterface) {
        return commonInterface != null && commonInterface.isInterface();
    }

    public static <T> Builder<T> forFeature(FeatureToggleConfiguration config, String featureName, Class<? super T> commonInterface) {
        return new Builder(config, featureName, commonInterface);
    }

    public static <T> SwitchableFeatureBuilder<T> forSwitchableFeaturesConfiguration(FeatureToggleConfiguration config, Class<? super T> commonInterface) {
        return new SwitchableFeatureBuilder<T>(config, commonInterface);
    }

    public static class SwitchableFeatureBuilder<T> {
        private FeatureToggleConfiguration config;
        private Class<? super T> commonInterface;
        private T defaultFeatureImpl;
        private LinkedHashMap<String, T> cases;

        public SwitchableFeatureBuilder(FeatureToggleConfiguration config, Class<? super T> commonInterface) {
            this.config = config;
            this.commonInterface = commonInterface;
            this.cases = new LinkedHashMap(4);
        }

        public SwitchableFeatureBuilder<T> when(String featureName, T featureImpl) {
            this.cases.put(featureName, featureImpl);
            return this;
        }

        public SwitchableFeatureBuilder<T> defaultFeature(T defaultFeatureImpl) {
            this.defaultFeatureImpl = defaultFeatureImpl;
            return this;
        }

        public T build() {
            if (this.cases.isEmpty()) {
                throw new IllegalStateException();
            }
            FeatureToggleFactory featureToggleFactory = new FeatureToggleFactory(this.config);
            Object main = null;
            ArrayList<Map.Entry<String, T>> featuresInformation = new ArrayList<Map.Entry<String, T>>(this.cases.entrySet());
            for (int i = featuresInformation.size() - 1; i >= 0; --i) {
                Object next = main == null ? (Object)this.defaultFeatureImpl : main;
                Map.Entry featureInformation = (Map.Entry)featuresInformation.get(i);
                main = featureToggleFactory.createFeatureProxy((String)featureInformation.getKey(), this.commonInterface, featureInformation.getValue(), next);
            }
            return (T)main;
        }
    }

    public static class Builder<T> {
        private SwitchableFeatureBuilder<T> switchableFeatureBuilder;
        private String featureName;

        private Builder(FeatureToggleConfiguration config, String featureName, Class<? super T> commonInterface) {
            this.switchableFeatureBuilder = new SwitchableFeatureBuilder<T>(config, commonInterface);
            this.featureName = featureName;
        }

        public Builder<T> whenEnabled(T featureOn) {
            this.switchableFeatureBuilder.when(this.featureName, featureOn);
            return this;
        }

        public Builder<T> whenDisabled(T featureOff) {
            this.switchableFeatureBuilder.defaultFeature(featureOff);
            return this;
        }

        public T build() {
            return this.switchableFeatureBuilder.build();
        }
    }
}

