/*
 * Decompiled with CFR 0.152.
 */
package org.blocks4j.feature.toggle.parameters;

import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.blocks4j.feature.toggle.FeatureToggleConfiguration;
import org.blocks4j.feature.toggle.annotation.parameters.ParameterToggle;
import org.blocks4j.feature.toggle.converter.TypeConverter;
import org.blocks4j.feature.toggle.domain.TogglableParameter;
import org.blocks4j.feature.toggle.exception.ParamtersToggleFactoryException;

public final class ParametersToggleHandler {
    private static final String PARAM_BY_FEATURE = "%s&%s";
    private static final TypeConverter CONVERTER = new TypeConverter();
    private static final HashSet<Class<?>> ALLOWED_PARAMETER_TOGGLE = Sets.newHashSet((Object[])new Class[]{Character.class, Byte.class, Short.class, Integer.class, Long.class, Boolean.class, String.class});
    private FeatureToggleConfiguration config;
    private Map<Method, List<TogglableParameter>> paramsMethodsCache = new HashMap<Method, List<TogglableParameter>>();

    public ParametersToggleHandler(FeatureToggleConfiguration config, Class<?> commonInterface) {
        this.loadParamtersTogglable(commonInterface);
        this.config = config;
    }

    private void loadParamtersTogglable(Class<?> commonInterface) {
        for (Method method : commonInterface.getDeclaredMethods()) {
            ArrayList togglableParameters = new ArrayList();
            this.extractAnnotatedToggleParametersOnPrimitiveMethodParameters(method, togglableParameters);
            this.extractAnnotatedToggleParametersOnComplexMethodParameters(method, togglableParameters);
            this.put(method, togglableParameters);
        }
    }

    public boolean isOn(Method method, Object[] args, String featureName) {
        List<TogglableParameter> togglableParameters = this.paramsMethodsCache.get(method);
        if (CollectionUtils.isEmpty(togglableParameters)) {
            return true;
        }
        for (TogglableParameter togglableParameter : togglableParameters) {
            if (this.isParamOn(args, featureName, togglableParameter)) continue;
            return false;
        }
        return true;
    }

    private boolean isParamOn(Object[] args, String featureName, TogglableParameter togglableParameter) {
        Collection<String> allowedParameters = this.getParamtersConfigured(togglableParameter);
        if (allowedParameters.isEmpty() && (allowedParameters = this.getParamtersByFeatureConfigured(featureName, togglableParameter)).isEmpty()) {
            return true;
        }
        return this.validateFeatureToggleParameters(args[togglableParameter.getIndex()], togglableParameter, allowedParameters);
    }

    private boolean validateFeatureToggleParameters(Object arg, TogglableParameter togglableParameter, Collection<String> allowedParameters) {
        Object togglableParameterValue = this.getTogglableParameterValue(togglableParameter, arg);
        return allowedParameters.contains(CONVERTER.convertToString(togglableParameterValue));
    }

    private Object getTogglableParameterValue(TogglableParameter<?> togglableParameter, Object arg) {
        Object togglableParameterValue;
        switch (togglableParameter.getAccessMethod()) {
            case DIRECT: {
                togglableParameterValue = arg;
                break;
            }
            case METHOD: {
                try {
                    TogglableParameter<?> methodTogglableParameter = togglableParameter;
                    togglableParameterValue = ((Method)methodTogglableParameter.getAccessibleObject()).invoke(arg, new Object[0]);
                    break;
                }
                catch (Exception e) {
                    throw new ParamtersToggleFactoryException(String.format("The method [%s] must be implemented! ", togglableParameter.getAccessibleObject()), e);
                }
            }
            case FIELD: {
                try {
                    TogglableParameter<?> fieldTogglableParameter = togglableParameter;
                    togglableParameterValue = ((Field)fieldTogglableParameter.getAccessibleObject()).get(arg);
                    break;
                }
                catch (Exception e) {
                    throw new ParamtersToggleFactoryException(String.format("Error accessing [%s] field! ", togglableParameter.getAccessibleObject()), e);
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return togglableParameterValue;
    }

    private void extractAnnotatedToggleParametersOnComplexMethodParameters(Method method, Collection<TogglableParameter<?>> togglableParameters) {
        int index = 0;
        for (Class<?> param : method.getParameterTypes()) {
            this.extractAnnotatedToggleParametersOnFields(index, param, togglableParameters);
            this.extractAnnotatedToggleParametersOnMethods(index, param, togglableParameters);
            ++index;
        }
    }

    private void extractAnnotatedToggleParametersOnMethods(int index, Class<?> param, Collection<TogglableParameter<?>> togglableParameters) {
        for (Method method : param.getDeclaredMethods()) {
            ParameterToggle annotation = method.getAnnotation(ParameterToggle.class);
            if (annotation == null) continue;
            try {
                if (!this.allowedParameterType(method.getReturnType())) {
                    throw new IllegalArgumentException("Parameter Toggle is not allowed here: " + method);
                }
                method.setAccessible(true);
                togglableParameters.add(TogglableParameter.createTogglableParameter(index, ((ParameterToggle)ParameterToggle.class.cast(annotation)).value(), method));
            }
            catch (Exception e) {
                throw new ParamtersToggleFactoryException(String.format("Error on registering the method [%s] for togglable parameter", method), e);
            }
        }
    }

    private void extractAnnotatedToggleParametersOnFields(int index, Class<?> param, Collection<TogglableParameter<?>> togglableParameters) {
        for (Field field : param.getDeclaredFields()) {
            ParameterToggle annotation = field.getAnnotation(ParameterToggle.class);
            if (annotation == null) continue;
            try {
                if (!this.allowedParameterType(field.getType())) {
                    throw new IllegalArgumentException("Parameter Toggle is not allowed here: " + field);
                }
                field.setAccessible(true);
                togglableParameters.add(TogglableParameter.createTogglableParameter(index, ((ParameterToggle)ParameterToggle.class.cast(annotation)).value(), field));
            }
            catch (Exception e) {
                throw new ParamtersToggleFactoryException(String.format("Error on registering the field [%s] for togglable parameter", field), e);
            }
        }
    }

    private void extractAnnotatedToggleParametersOnPrimitiveMethodParameters(Method method, Collection<TogglableParameter<?>> togglableParameters) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        HashMap<Integer, String> parameterToggleIndexes = new HashMap<Integer, String>();
        this.extractParameterToggleIndexes(method, parameterToggleIndexes);
        for (Map.Entry parametersToggle : parameterToggleIndexes.entrySet()) {
            Integer parameterIndex = (Integer)parametersToggle.getKey();
            String parameterToggleName = (String)parametersToggle.getValue();
            if (this.allowedParameterType(parameterTypes[parameterIndex])) {
                togglableParameters.add(TogglableParameter.createTogglableParameter(parameterIndex, parameterToggleName));
                continue;
            }
            throw new IllegalArgumentException("Parameter Toggle is not allowed here: " + method);
        }
    }

    private void extractParameterToggleIndexes(Method method, Map<Integer, String> parameterToggleIndexes) {
        int index = 0;
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = arr$[i$]) {
                if (!(annotation instanceof ParameterToggle)) continue;
                parameterToggleIndexes.put(index, ((ParameterToggle)annotation).value());
            }
            ++index;
        }
    }

    private boolean allowedParameterType(Class<?> parameterType) {
        return ALLOWED_PARAMETER_TOGGLE.contains(Primitives.wrap(parameterType)) || Enum.class.isAssignableFrom(parameterType);
    }

    private void put(Method method, Collection<TogglableParameter<?>> togglableParameters) {
        List<TogglableParameter> list = this.paramsMethodsCache.get(method);
        if (list == null) {
            list = new ArrayList<TogglableParameter>();
            this.paramsMethodsCache.put(method, list);
        }
        list.addAll(togglableParameters);
    }

    private Collection<String> getParamtersConfigured(TogglableParameter togglableParameter) {
        return this.getConfigured(togglableParameter.getId());
    }

    private Collection<String> getParamtersByFeatureConfigured(String featureName, TogglableParameter togglableParameter) {
        return this.getConfigured(String.format(PARAM_BY_FEATURE, featureName, togglableParameter.getId()));
    }

    private Collection<String> getConfigured(String key) {
        Collection paramtersConfigured = this.config.getEnabledParameters().get(key);
        if (paramtersConfigured == null) {
            return Collections.emptyList();
        }
        return paramtersConfigured;
    }
}

